/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubGist {
    @NotNull
    private final String myId;
    @NotNull
    private final String myDescription;
    private final boolean myIsPublic;
    @NotNull
    private final String myHtmlUrl;
    @NotNull
    private final List<GistFile> myFiles;
    @Nullable
    private final GithubUser myUser;

    @NotNull
    public List<FileContent> getContent() {
        ArrayList<FileContent> ret = new ArrayList<FileContent>();
        for (GistFile file : this.getFiles()) {
            ret.add(new FileContent(file.getFilename(), file.getContent()));
        }
        return ret;
    }

    public GithubGist(@NotNull String id, @Nullable String description, boolean isPublic, @NotNull String htmlUrl, @NotNull List<GistFile> files, @Nullable GithubUser user) {
        this.myId = id;
        this.myDescription = StringUtil.notNullize((String)description);
        this.myIsPublic = isPublic;
        this.myHtmlUrl = htmlUrl;
        this.myFiles = files;
        this.myUser = user;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public boolean isPublic() {
        return this.myIsPublic;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.myHtmlUrl;
    }

    @NotNull
    public List<GistFile> getFiles() {
        return this.myFiles;
    }

    @Nullable
    public GithubUser getUser() {
        return this.myUser;
    }

    public static class FileContent {
        @NotNull
        private final String myFileName;
        @NotNull
        private final String myContent;

        public FileContent(@NotNull String fileName, @NotNull String content) {
            this.myFileName = fileName;
            this.myContent = content;
        }

        @NotNull
        public String getFileName() {
            return this.myFileName;
        }

        @NotNull
        public String getContent() {
            return this.myContent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileContent that = (FileContent)o;
            if (!this.myContent.equals(that.myContent)) {
                return false;
            }
            return this.myFileName.equals(that.myFileName);
        }

        public int hashCode() {
            int result = this.myFileName.hashCode();
            result = 31 * result + this.myContent.hashCode();
            return result;
        }
    }

    public static class GistFile {
        @NotNull
        private final String myFilename;
        @NotNull
        private final String myContent;
        @NotNull
        private final String myRawUrl;

        public GistFile(@NotNull String filename, @NotNull String content, @NotNull String rawUrl) {
            this.myFilename = filename;
            this.myContent = content;
            this.myRawUrl = rawUrl;
        }

        @NotNull
        public String getFilename() {
            return this.myFilename;
        }

        @NotNull
        public String getContent() {
            return this.myContent;
        }

        @NotNull
        public String getRawUrl() {
            return this.myRawUrl;
        }
    }
}

