/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubConnection {
    private static final Logger LOG = GithubUtil.LOG;
    private static final HttpRequestInterceptor PREEMPTIVE_BASIC_AUTH = new PreemptiveBasicAuthInterceptor();
    @NotNull
    private final String myHost;
    @NotNull
    private final CloseableHttpClient myClient;
    private final boolean myReusable;
    private volatile HttpUriRequest myRequest;
    private volatile boolean myAborted;

    public GithubConnection(@NotNull GithubAuthData auth) {
        this(auth, false);
    }

    public GithubConnection(@NotNull GithubAuthData auth, boolean reusable) {
        this.myHost = auth.getHost();
        this.myClient = GithubConnection.createClient(auth);
        this.myReusable = reusable;
    }

    @Nullable
    public JsonElement getRequest(@NotNull String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.GET).getJsonElement();
    }

    @Nullable
    public JsonElement postRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.POST).getJsonElement();
    }

    @Nullable
    public JsonElement patchRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.PATCH).getJsonElement();
    }

    @Nullable
    public JsonElement deleteRequest(@NotNull String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.DELETE).getJsonElement();
    }

    @NotNull
    public Header[] headRequest(@NotNull String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.HEAD).getHeaders();
    }

    @NotNull
    public String getHost() {
        return this.myHost;
    }

    public void abort() {
        if (this.myAborted) {
            return;
        }
        this.myAborted = true;
        HttpUriRequest request = this.myRequest;
        if (request != null) {
            request.abort();
        }
    }

    public void close() throws IOException {
        this.myClient.close();
    }

    @NotNull
    private static CloseableHttpClient createClient(@NotNull GithubAuthData auth) {
        HttpClientBuilder builder = HttpClients.custom();
        return builder.setDefaultRequestConfig(GithubConnection.createRequestConfig(auth)).setDefaultConnectionConfig(GithubConnection.createConnectionConfig(auth)).setDefaultCredentialsProvider(GithubConnection.createCredentialsProvider(auth)).setDefaultHeaders(GithubConnection.createHeaders(auth)).addInterceptorFirst(PREEMPTIVE_BASIC_AUTH).setSslcontext(CertificateManager.getInstance().getSslContext()).setHostnameVerifier((X509HostnameVerifier)CertificateManager.HOSTNAME_VERIFIER).build();
    }

    @NotNull
    private static RequestConfig createRequestConfig(@NotNull GithubAuthData auth) {
        RequestConfig.Builder builder = RequestConfig.custom();
        int timeout = GithubSettings.getInstance().getConnectionTimeout();
        builder.setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (auth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyForUrlIfEnabled((RequestConfig.Builder)builder, (String)auth.getHost());
        }
        return builder.build();
    }

    @NotNull
    private static ConnectionConfig createConnectionConfig(@NotNull GithubAuthData auth) {
        return ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
    }

    @NotNull
    private static CredentialsProvider createCredentialsProvider(@NotNull GithubAuthData auth) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
        if (basicAuth != null) {
            provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuth.getLogin(), basicAuth.getPassword()));
        }
        if (auth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsForUrlIfEnabled((CredentialsProvider)provider, (String)auth.getHost());
        }
        return provider;
    }

    @NotNull
    private static Collection<? extends Header> createHeaders(@NotNull GithubAuthData auth) {
        GithubAuthData.BasicAuth basicAuth;
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
        if (tokenAuth != null) {
            headers.add(new BasicHeader("Authorization", "token " + tokenAuth.getToken()));
        }
        if ((basicAuth = auth.getBasicAuth()) != null && basicAuth.getCode() != null) {
            headers.add(new BasicHeader("X-GitHub-OTP", basicAuth.getCode()));
        }
        return headers;
    }

    @NotNull
    private static String getRequestUrl(@NotNull String host, @NotNull String path) {
        return GithubUrlUtil.getApiUrl(host) + path;
    }

    @NotNull
    private ResponsePage request(@NotNull String path, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        return this.doRequest(GithubConnection.getRequestUrl(this.myHost, path), requestBody, headers, verb);
    }

    @NotNull
    private ResponsePage doRequest(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Network operation in EDT");
        }
        CloseableHttpResponse response = null;
        try {
            response = this.doREST(uri, requestBody, headers, verb);
            if (this.myAborted) {
                throw new GithubOperationCanceledException();
            }
            GithubConnection.checkStatusCode(response, requestBody);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                ResponsePage responsePage = this.createResponse(response);
                return responsePage;
            }
            JsonElement ret = GithubConnection.parseResponse(entity.getContent());
            if (ret.isJsonNull()) {
                ResponsePage responsePage = this.createResponse(response);
                return responsePage;
            }
            String nextPage = null;
            Header pageHeader = response.getFirstHeader("Link");
            if (pageHeader != null) {
                for (HeaderElement element : pageHeader.getElements()) {
                    NameValuePair rel = element.getParameterByName("rel");
                    if (rel == null || !"next".equals(rel.getValue())) continue;
                    String urlString = element.toString();
                    int begin = urlString.indexOf(60);
                    int end = urlString.lastIndexOf(62);
                    if (begin == -1 || end == -1) {
                        LOG.error("Invalid 'Link' header", new String[]{"{" + pageHeader.toString() + "}"});
                        break;
                    }
                    nextPage = urlString.substring(begin + 1, end);
                    break;
                }
            }
            ResponsePage responsePage = this.createResponse(ret, nextPage, response);
            return responsePage;
        }
        catch (SSLHandshakeException e) {
            if (e.getCause() instanceof CertificateException) {
                LOG.info("Host SSL certificate is not trusted", (Throwable)e);
                throw new GithubOperationCanceledException("Host SSL certificate is not trusted", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (this.myAborted) {
                throw new GithubOperationCanceledException("Operation canceled", e);
            }
            throw e;
        }
        finally {
            this.myRequest = null;
            if (response != null) {
                response.close();
            }
            if (!this.myReusable) {
                this.myClient.close();
            }
        }
    }

    @NotNull
    private CloseableHttpResponse doREST(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        HttpPost request;
        switch (verb) {
            case POST: {
                request = new HttpPost(uri);
                if (requestBody == null) break;
                request.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case PATCH: {
                request = new HttpPatch(uri);
                if (requestBody == null) break;
                ((HttpPatch)request).setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HttpVerb: " + verb.toString());
            }
        }
        for (Header header : headers) {
            request.addHeader(header);
        }
        this.myRequest = request;
        return this.myClient.execute((HttpUriRequest)request);
    }

    private static void checkStatusCode(@NotNull CloseableHttpResponse response, @Nullable String body) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                return;
            }
            case 401: 
            case 402: 
            case 403: {
                GithubStatusCodeException error = GithubConnection.getStatusCodeException(response);
                Header headerOTP = response.getFirstHeader("X-GitHub-OTP");
                if (headerOTP != null) {
                    for (HeaderElement element : headerOTP.getElements()) {
                        if (!"required".equals(element.getName())) continue;
                        throw new GithubTwoFactorAuthenticationException(error.getMessage());
                    }
                }
                if (error.getError() != null && error.getError().containsReasonMessage("API rate limit exceeded")) {
                    throw new GithubRateLimitExceededException(error.getMessage());
                }
                throw new GithubAuthenticationException("Request response: " + error.getMessage());
            }
            case 400: 
            case 422: {
                LOG.info("body message:" + body);
                throw GithubConnection.getStatusCodeException(response);
            }
        }
        throw GithubConnection.getStatusCodeException(response);
    }

    @NotNull
    private static GithubStatusCodeException getStatusCodeException(@NotNull CloseableHttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                GithubErrorMessage error = GithubApiUtil.fromJson(GithubConnection.parseResponse(entity.getContent()), GithubErrorMessage.class);
                String message = statusLine.getReasonPhrase() + " - " + error.getMessage();
                return new GithubStatusCodeException(message, error, statusLine.getStatusCode());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return new GithubStatusCodeException(statusLine.getReasonPhrase(), statusLine.getStatusCode());
    }

    @NotNull
    private static JsonElement parseResponse(@NotNull InputStream githubResponse) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(githubResponse, CharsetToolkit.UTF8_CHARSET);){
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
    }

    private ResponsePage createResponse(@NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(null, null, response.getAllHeaders());
    }

    private ResponsePage createResponse(@NotNull JsonElement ret, @Nullable String path, @NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(ret, path, response.getAllHeaders());
    }

    private static class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveBasicAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials credentials = provider.getCredentials(AuthScope.ANY);
            if (credentials != null) {
                request.addHeader(new BasicScheme(Consts.UTF_8).authenticate(credentials, request, context));
            }
        }
    }

    private static class ResponsePage {
        @Nullable
        private final JsonElement myResponse;
        @Nullable
        private final String myNextPage;
        @NotNull
        private final Header[] myHeaders;

        public ResponsePage(@Nullable JsonElement response, @Nullable String next, @NotNull Header[] headers) {
            this.myResponse = response;
            this.myNextPage = next;
            this.myHeaders = headers;
        }

        @Nullable
        public JsonElement getJsonElement() {
            return this.myResponse;
        }

        @Nullable
        public String getNextPage() {
            return this.myNextPage;
        }

        @NotNull
        public Header[] getHeaders() {
            return this.myHeaders;
        }
    }

    public static class PagedRequest<T> {
        @NotNull
        private String myPath;
        @NotNull
        private final Collection<Header> myHeaders;
        @NotNull
        private final Class<T> myResult;
        @NotNull
        private final Class<? extends DataConstructor[]> myRawArray;
        private boolean myFirstRequest = true;
        @Nullable
        private String myNextPage;

        public PagedRequest(@NotNull String path, @NotNull Class<T> result, @NotNull Class<? extends DataConstructor[]> rawArray, Header ... headers) {
            this.myPath = path;
            this.myResult = result;
            this.myRawArray = rawArray;
            this.myHeaders = Arrays.asList(headers);
        }

        @NotNull
        public List<T> next(@NotNull GithubConnection connection) throws IOException {
            String url;
            if (this.myFirstRequest) {
                url = GithubConnection.getRequestUrl(connection.getHost(), this.myPath);
                this.myFirstRequest = false;
            } else {
                if (this.myNextPage == null) {
                    throw new NoSuchElementException();
                }
                url = this.myNextPage;
                this.myNextPage = null;
            }
            ResponsePage response = connection.doRequest(url, null, this.myHeaders, HttpVerb.GET);
            if (response.getJsonElement() == null) {
                throw new GithubConfusingException("Empty response");
            }
            if (!response.getJsonElement().isJsonArray()) {
                throw new GithubJsonException("Wrong json type: expected JsonArray", new Exception(response.getJsonElement().toString()));
            }
            this.myNextPage = response.getNextPage();
            ArrayList<T> result = new ArrayList<T>();
            for (DataConstructor raw : GithubApiUtil.fromJson((JsonElement)response.getJsonElement().getAsJsonArray(), this.myRawArray)) {
                result.add(GithubApiUtil.createDataFromRaw(raw, this.myResult));
            }
            return result;
        }

        public boolean hasNext() {
            return this.myFirstRequest || this.myNextPage != null;
        }

        @NotNull
        public List<T> getAll(@NotNull GithubConnection connection) throws IOException {
            ArrayList<T> result = new ArrayList<T>();
            while (this.hasNext()) {
                result.addAll(this.next(connection));
            }
            return result;
        }
    }

    private static enum HttpVerb {
        GET,
        POST,
        DELETE,
        HEAD,
        PATCH;

    }
}

