/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import git4idea.util.GitUIUtil;
import icons.GithubIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShareAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;

    public GithubShareAction() {
        super("Share Project on GitHub", "Easily share project on GitHub", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GithubUtil.setVisibleEnabled(e, true, true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !GithubUtil.testGitExecutable(project)) {
            return;
        }
        GithubShareAction.shareProjectOnGithub(project, file);
    }

    public static void shareProjectOnGithub(final @NotNull Project project, @Nullable VirtualFile file) {
        GithubInfo githubInfo;
        BasicAction.saveAll();
        GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        final boolean gitDetected = gitRepository != null;
        final VirtualFile root = gitDetected ? gitRepository.getRoot() : project.getBaseDir();
        final GithubAuthDataHolder authHolder = GithubAuthDataHolder.createFromSettings();
        Set existingRemotes = Collections.emptySet();
        if (gitDetected) {
            String githubRemote = GithubUtil.findGithubRemoteUrl(gitRepository);
            if (githubRemote != null && !GithubShareAction.checkExistingRemote(project, authHolder, githubRemote)) {
                return;
            }
            existingRemotes = ContainerUtil.map2Set((Collection)gitRepository.getRemotes(), (Function)new Function<GitRemote, String>(){

                public String fun(GitRemote remote) {
                    return remote.getName();
                }
            });
        }
        if ((githubInfo = GithubShareAction.loadGithubInfoWithModal(authHolder, project)) == null) {
            return;
        }
        GithubShareDialog shareDialog = new GithubShareDialog(project, (Set<String>)githubInfo.getRepositoryNames(), existingRemotes, githubInfo.getUser().canCreatePrivateRepo());
        DialogManager.show((DialogWrapper)shareDialog);
        if (!shareDialog.isOK()) {
            return;
        }
        final boolean isPrivate = shareDialog.isPrivate();
        final String name = shareDialog.getRepositoryName();
        final String description = shareDialog.getDescription();
        final String remoteName = shareDialog.getRemoteName();
        new Task.Backgroundable(project, "Sharing project on GitHub..."){

            public void run(@NotNull ProgressIndicator indicator) {
                GitRepositoryManager repositoryManager;
                GitRepository repository;
                LOG.info("Creating GitHub repository");
                indicator.setText("Creating GitHub repository...");
                String url = GithubShareAction.createGithubRepository(project, authHolder, indicator, name, description, isPrivate);
                if (url == null) {
                    return;
                }
                LOG.info("Successfully created GitHub repository");
                LOG.info("Binding local project with GitHub");
                if (!gitDetected) {
                    LOG.info("No git detected, creating empty git repo");
                    indicator.setText("Creating empty git repo...");
                    if (!GithubShareAction.createEmptyGitRepository(project, root, indicator)) {
                        return;
                    }
                }
                if ((repository = (GitRepository)(repositoryManager = GitUtil.getRepositoryManager((Project)project)).getRepositoryForRoot(root)) == null) {
                    GithubNotifications.showError(project, "Failed to create GitHub Repository", "Can't find Git repository");
                    return;
                }
                String remoteUrl = GithubUrlUtil.getCloneUrl(githubInfo.getUser().getLogin(), name);
                LOG.info("Adding GitHub as a remote host");
                indicator.setText("Adding GitHub as a remote host...");
                if (!GithubUtil.addGithubRemote(project, repository, remoteName, remoteUrl)) {
                    return;
                }
                if (!GithubShareAction.performFirstCommitIfRequired(project, root, repository, indicator, name, url)) {
                    return;
                }
                LOG.info("Pushing to github master");
                indicator.setText("Pushing to github master...");
                if (!GithubShareAction.pushCurrentBranch(project, repository, remoteName, remoteUrl, name, url)) {
                    return;
                }
                GithubNotifications.showInfoURL(project, "Successfully shared project on GitHub", name, url);
            }
        }.queue();
    }

    private static boolean checkExistingRemote(final @NotNull Project project, final @NotNull GithubAuthDataHolder authHolder, @NotNull String remote) {
        final GithubFullPath path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote);
        if (path == null) {
            return GithubNotifications.showYesNoDialog(project, "Project Is Already on GitHub", "Can't connect to repository from configured remote. You could want to check .git config.\nDo you want to proceed anyway?");
        }
        try {
            GithubRepo repo = GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubRepo, IOException>(){

                @NotNull
                public GithubRepo convert(ProgressIndicator indicator) throws IOException {
                    return GithubUtil.runTask(project, authHolder, indicator, new ThrowableConvertor<GithubConnection, GithubRepo, IOException>(){

                        @NotNull
                        public GithubRepo convert(@NotNull GithubConnection connection) throws IOException {
                            return GithubApiUtil.getDetailedRepoInfo(connection, path.getUser(), path.getRepository());
                        }
                    });
                }
            });
            int result = Messages.showDialog((Project)project, (String)("Successfully connected to " + repo.getHtmlUrl() + ".\n" + "Do you want to proceed anyway?"), (String)"Project Is Already on GitHub", (String[])new String[]{"Continue", "Open in Browser", Messages.CANCEL_BUTTON}, (int)2, (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                BrowserUtil.browse((String)repo.getHtmlUrl());
            }
            return false;
        }
        catch (GithubStatusCodeException e) {
            if (e.getStatusCode() == 404) {
                return GithubNotifications.showYesNoDialog(project, "Project Is Already on GitHub", "Can't connect to repository from configured remote. You could want to check .git config.\nDo you want to proceed anyway?");
            }
            GithubNotifications.showErrorDialog(project, "Failed to Connect to GitHub", (Exception)e);
            return false;
        }
        catch (IOException e) {
            GithubNotifications.showErrorDialog(project, "Failed to Connect to GitHub", (Exception)e);
            return false;
        }
    }

    @Nullable
    private static GithubInfo loadGithubInfoWithModal(final @NotNull GithubAuthDataHolder authHolder, final @NotNull Project project) {
        try {
            return GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubInfo, IOException>(){

                @NotNull
                public GithubInfo convert(ProgressIndicator indicator) throws IOException {
                    return GithubUtil.runTask(project, authHolder, indicator, new ThrowableConvertor<GithubConnection, GithubInfo, IOException>(){

                        @NotNull
                        public GithubInfo convert(@NotNull GithubConnection connection) throws IOException {
                            GithubUserDetailed userInfo = GithubApiUtil.getCurrentUserDetailed(connection);
                            HashSet names = new HashSet();
                            for (GithubRepo info : GithubApiUtil.getUserRepos(connection)) {
                                names.add((Object)info.getName());
                            }
                            return new GithubInfo(userInfo, (HashSet<String>)names);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showErrorDialog(project, "Failed to Connect to GitHub", (Exception)e);
            return null;
        }
    }

    @Nullable
    private static String createGithubRepository(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, final @NotNull String name, final @NotNull String description, final boolean isPrivate) {
        try {
            return GithubUtil.runTask(project, authHolder, indicator, new ThrowableConvertor<GithubConnection, GithubRepo, IOException>(){

                @NotNull
                public GithubRepo convert(@NotNull GithubConnection connection) throws IOException {
                    return GithubApiUtil.createRepo(connection, name, description, isPrivate);
                }
            }).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Failed to create GitHub Repository", e);
            return null;
        }
    }

    private static boolean createEmptyGitRepository(@NotNull Project project, @NotNull VirtualFile root, @NotNull ProgressIndicator indicator) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        h.setStdoutSuppressed(false);
        GitHandlerUtil.runInCurrentThread((GitHandler)h, (ProgressIndicator)indicator, (boolean)true, (String)GitBundle.getString((String)"initializing.title"));
        if (!h.errors().isEmpty()) {
            GitUIUtil.showOperationErrors((Project)project, (Collection)h.errors(), (String)"git init");
            LOG.info("Failed to create empty git repo: " + h.errors());
            return false;
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
        return true;
    }

    private static boolean performFirstCommitIfRequired(final @NotNull Project project, @NotNull VirtualFile root, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator, @NotNull String name, @NotNull String url) {
        if (!repository.isFresh()) {
            return true;
        }
        LOG.info("Trying to commit");
        try {
            LOG.info("Adding files for commit");
            indicator.setText("Adding files to git...");
            final List trackedFiles = ChangeListManager.getInstance((Project)project).getAffectedFiles();
            Collection<VirtualFile> untrackedFiles = GithubShareAction.filterOutIgnored(project, repository.getUntrackedFilesHolder().retrieveUntrackedFiles());
            trackedFiles.removeAll(untrackedFiles);
            final ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
            allFiles.addAll(trackedFiles);
            allFiles.addAll(untrackedFiles);
            final Ref dialogRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GithubUntrackedFilesDialog dialog = new GithubUntrackedFilesDialog(project, allFiles);
                    if (!trackedFiles.isEmpty()) {
                        dialog.setSelectedFiles(trackedFiles);
                    }
                    DialogManager.show((DialogWrapper)dialog);
                    dialogRef.set((Object)dialog);
                }
            }, indicator.getModalityState());
            GithubUntrackedFilesDialog dialog = (GithubUntrackedFilesDialog)((Object)dialogRef.get());
            Collection files2commit = dialog.getSelectedFiles();
            if (!dialog.isOK() || files2commit.isEmpty()) {
                GithubNotifications.showInfoURL(project, "Successfully created empty repository on GitHub", name, url);
                return false;
            }
            Collection files2add = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
            Collection files2rm = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
            HashSet modified = new HashSet((Collection)trackedFiles);
            modified.addAll(files2commit);
            GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
            GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
            LOG.info("Performing commit");
            indicator.setText("Performing commit...");
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{"-m", dialog.getCommitMessage()});
            handler.endOptions();
            handler.run();
            VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", "'" + name + "'", " on GitHub, but initial commit failed:<br/>" + GithubUtil.getErrorTextFromException((Exception)((Object)e)), url);
            return false;
        }
        LOG.info("Successfully created initial commit");
        return true;
    }

    @NotNull
    private static Collection<VirtualFile> filterOutIgnored(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        final ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return ContainerUtil.filter(files, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return !changeListManager.isIgnoredFile(file) && !vcsManager.isIgnored(file);
            }
        });
    }

    private static boolean pushCurrentBranch(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String name, @NotNull String url) {
        Git git = (Git)ServiceManager.getService(Git.class);
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", "'" + name + "'", " on GitHub, but initial push failed: no current branch", url);
            return false;
        }
        GitCommandResult result = git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
        if (!result.success()) {
            GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", "'" + name + "'", " on GitHub, but initial push failed:<br/>" + result.getErrorOutputAsHtmlString(), url);
            return false;
        }
        return true;
    }

    private static class GithubInfo {
        @NotNull
        private final GithubUserDetailed myUser;
        @NotNull
        private final HashSet<String> myRepositoryNames;

        GithubInfo(@NotNull GithubUserDetailed user, @NotNull HashSet<String> repositoryNames) {
            this.myUser = user;
            this.myRepositoryNames = repositoryNames;
        }

        @NotNull
        public GithubUserDetailed getUser() {
            return this.myUser;
        }

        @NotNull
        public HashSet<String> getRepositoryNames() {
            return this.myRepositoryNames;
        }
    }

    public static class GithubUntrackedFilesDialog
    extends SelectFilesDialog
    implements TypeSafeDataProvider {
        @NotNull
        private final Project myProject;
        private CommitMessage myCommitMessagePanel;

        public GithubUntrackedFilesDialog(@NotNull Project project, @NotNull List<VirtualFile> untrackedFiles) {
            super(project, untrackedFiles, null, null, true, false, false);
            this.myProject = project;
            this.setTitle("Add Files For Initial Commit");
            this.init();
        }

        protected JComponent createNorthPanel() {
            return null;
        }

        protected JComponent createCenterPanel() {
            JComponent tree = super.createCenterPanel();
            this.myCommitMessagePanel = new CommitMessage(this.myProject);
            this.myCommitMessagePanel.setCommitMessage("Initial commit");
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return splitter;
        }

        @NotNull
        public String getCommitMessage() {
            return this.myCommitMessagePanel.getComment();
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == VcsDataKeys.COMMIT_MESSAGE_CONTROL) {
                sink.put(VcsDataKeys.COMMIT_MESSAGE_CONTROL, (Object)this.myCommitMessagePanel);
            }
        }

        protected String getDimensionServiceKey() {
            return "Github.UntrackedFilesDialog";
        }
    }
}

