/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.repo.GitRepository;
import icons.GithubIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestDialog;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreatePullRequestAction
extends DumbAwareAction {
    public GithubCreatePullRequestAction() {
        super("Create Pull Request", "Create pull request from current branch", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault()) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        if (gitRepository == null) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        if (!GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GithubUtil.setVisibleEnabled(e, true, true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !GithubUtil.testGitExecutable(project)) {
            return;
        }
        GithubCreatePullRequestAction.createPullRequest(project, file);
    }

    static void createPullRequest(@NotNull Project project, @Nullable VirtualFile file) {
        GithubCreatePullRequestWorker worker = GithubCreatePullRequestWorker.create(project, file);
        if (worker == null) {
            return;
        }
        GithubCreatePullRequestDialog dialog = new GithubCreatePullRequestDialog(project, worker);
        DialogManager.show((DialogWrapper)dialog);
    }
}

