/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConvertor;
import icons.GithubIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubGist;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String FAILED_TO_CREATE_GIST = "Can't create Gist";

    protected GithubCreateGistAction() {
        super("Create Gist...", "Create GitHub Gist", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null || editor != null && editor.getDocument().getTextLength() == 0) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GithubUtil.setVisibleEnabled(e, true, true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, file, files);
    }

    static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final @Nullable VirtualFile[] files) {
        final GithubCreateGistDialog dialog = new GithubCreateGistDialog(project, editor, files, file);
        if (!dialog.showAndGet()) {
            return;
        }
        final GithubAuthDataHolder authHolder = GithubCreateGistAction.getValidAuthData(project, dialog.isAnonymous());
        if (authHolder == null) {
            return;
        }
        final Ref url = new Ref();
        new Task.Backgroundable(project, "Creating Gist..."){

            public void run(@NotNull ProgressIndicator indicator) {
                List<GithubGist.FileContent> contents = GithubCreateGistAction.collectContents(project, editor, file, files);
                String gistUrl = GithubCreateGistAction.createGist(project, authHolder, indicator, contents, dialog.isPrivate(), dialog.getDescription(), dialog.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "Gist Created Successfully", "Your gist url", (String)url.get());
                }
            }
        }.queue();
    }

    @Nullable
    private static GithubAuthDataHolder getValidAuthData(final @NotNull Project project, boolean isAnonymous) {
        if (isAnonymous) {
            return new GithubAuthDataHolder(GithubAuthData.createAnonymous());
        }
        try {
            return GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubAuthDataHolder, IOException>(){

                @NotNull
                public GithubAuthDataHolder convert(ProgressIndicator indicator) throws IOException {
                    return GithubUtil.getValidAuthDataHolderFromConfig(project, indicator);
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Can't create gist", e);
            return null;
        }
    }

    @NotNull
    static List<GithubGist.FileContent> collectContents(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, @Nullable VirtualFile[] files) {
        if (editor != null) {
            String content = GithubCreateGistAction.getContentFromEditor(editor);
            if (content == null) {
                return Collections.emptyList();
            }
            if (file != null) {
                return Collections.singletonList(new GithubGist.FileContent(file.getName(), content));
            }
            return Collections.singletonList(new GithubGist.FileContent("", content));
        }
        if (files != null) {
            ArrayList<GithubGist.FileContent> contents = new ArrayList<GithubGist.FileContent>();
            for (VirtualFile vf : files) {
                contents.addAll(GithubCreateGistAction.getContentFromFile(vf, project, null));
            }
            return contents;
        }
        if (file != null) {
            return GithubCreateGistAction.getContentFromFile(file, project, null);
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    static String createGist(@NotNull Project project, @NotNull GithubAuthDataHolder auth, @NotNull ProgressIndicator indicator, @NotNull List<GithubGist.FileContent> contents, final boolean isPrivate, final @NotNull String description, @Nullable String filename) {
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't create empty gist");
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGist.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGist.FileContent(filename, entry.getContent()));
        }
        try {
            final List<GithubGist.FileContent> finalContents = contents;
            return GithubUtil.runTask(project, auth, indicator, new ThrowableConvertor<GithubConnection, GithubGist, IOException>(){

                @NotNull
                public GithubGist convert(@NotNull GithubConnection connection) throws IOException {
                    return GithubApiUtil.createGist(connection, finalContents, description, isPrivate);
                }
            }).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, FAILED_TO_CREATE_GIST, e);
            return null;
        }
    }

    @Nullable
    private static String getContentFromEditor(final @NotNull Editor editor) {
        String text = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                return editor.getSelectionModel().getSelectedText();
            }
        });
        if (text == null) {
            text = editor.getDocument().getText();
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return text;
    }

    @NotNull
    private static List<GithubGist.FileContent> getContentFromFile(final @NotNull VirtualFile file, @NotNull Project project, @Nullable String prefix) {
        if (file.isDirectory()) {
            return GithubCreateGistAction.getContentFromDirectory(file, project, prefix);
        }
        String content = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                try {
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    if (document != null) {
                        return document.getText();
                    }
                    return new String(file.contentsToByteArray(), file.getCharset());
                }
                catch (IOException e) {
                    LOG.info("Couldn't read contents of the file " + file, (Throwable)e);
                    return null;
                }
            }
        });
        if (content == null) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Couldn't read the contents of the file " + file);
            return Collections.emptyList();
        }
        if (StringUtil.isEmptyOrSpaces((String)content)) {
            return Collections.emptyList();
        }
        String filename = GithubCreateGistAction.addPrefix(file.getName(), prefix, false);
        return Collections.singletonList(new GithubGist.FileContent(filename, content));
    }

    @NotNull
    private static List<GithubGist.FileContent> getContentFromDirectory(@NotNull VirtualFile dir, @NotNull Project project, @Nullable String prefix) {
        ArrayList<GithubGist.FileContent> contents = new ArrayList<GithubGist.FileContent>();
        for (VirtualFile file : dir.getChildren()) {
            if (GithubCreateGistAction.isFileIgnored(file, project)) continue;
            String pref = GithubCreateGistAction.addPrefix(dir.getName(), prefix, true);
            contents.addAll(GithubCreateGistAction.getContentFromFile(file, project, pref));
        }
        return contents;
    }

    private static String addPrefix(@NotNull String name, @Nullable String prefix, boolean addTrailingSlash) {
        String pref = prefix == null ? "" : prefix;
        pref = pref + name;
        if (addTrailingSlash) {
            pref = pref + "_";
        }
        return pref;
    }

    private static boolean isFileIgnored(@NotNull VirtualFile file, @NotNull Project project) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        return manager.isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }
}

