/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.store;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.internal.cache.Store;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedStoreFactory<T>
implements Closeable {
    private static final Logger LOG = Logging.getLogger(CachedStoreFactory.class);
    private final Cache<Object, T> cache;
    private final Stats stats;
    private String displayName;

    public CachedStoreFactory(String displayName) {
        this.displayName = displayName;
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10000L, TimeUnit.MILLISECONDS).build();
        this.stats = new Stats();
    }

    public Store<T> createCachedStore(Object id) {
        return new SimpleStore<T>(this.cache, id, this.stats);
    }

    @Override
    public void close() {
        LOG.debug(this.displayName + " cache closed. Cache reads: " + this.stats.readsFromCache + ", disk reads: " + this.stats.readsFromDisk + " (avg: " + Clock.prettyTime((long)this.stats.getDiskReadsAvgMs()) + ", total: " + Clock.prettyTime((long)this.stats.diskReadsTotalMs.get()) + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleStore<T>
    implements Store<T> {
        private Cache<Object, T> cache;
        private final Object id;
        private Stats stats;

        public SimpleStore(Cache<Object, T> cache, Object id, Stats stats) {
            this.cache = cache;
            this.id = id;
            this.stats = stats;
        }

        public T load(Factory<T> createIfNotPresent) {
            Object out = this.cache.getIfPresent(this.id);
            if (out != null) {
                this.stats.readFromCache();
                return (T)out;
            }
            long start = System.currentTimeMillis();
            Object value = createIfNotPresent.create();
            this.stats.readFromDisk(start);
            this.cache.put(this.id, value);
            return (T)value;
        }
    }

    private static class Stats {
        private final AtomicLong diskReadsTotalMs = new AtomicLong();
        private final AtomicLong readsFromCache = new AtomicLong();
        private final AtomicLong readsFromDisk = new AtomicLong();

        private Stats() {
        }

        public void readFromDisk(long start) {
            long duration = System.currentTimeMillis() - start;
            this.readsFromDisk.incrementAndGet();
            this.diskReadsTotalMs.addAndGet(duration);
        }

        public void readFromCache() {
            this.readsFromCache.incrementAndGet();
        }

        public long getDiskReadsAvgMs() {
            if (this.readsFromDisk.get() == 0L) {
                return 0L;
            }
            return this.diskReadsTotalMs.get() / this.readsFromDisk.get();
        }
    }
}

