/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.DefaultUnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphPathResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationBuilder;
import org.gradle.internal.resolve.ModuleVersionResolveException;

public class ResolvedConfigurationDependencyGraphVisitor
implements DependencyGraphVisitor,
DependencyArtifactsVisitor {
    private final ResolvedConfigurationBuilder builder;
    private final Map<ModuleVersionSelector, BrokenDependency> failuresByRevisionId = new LinkedHashMap<ModuleVersionSelector, BrokenDependency>();
    private DependencyGraphNode root;

    public ResolvedConfigurationDependencyGraphVisitor(ResolvedConfigurationBuilder builder) {
        this.builder = builder;
    }

    public void start(DependencyGraphNode root) {
        this.root = root;
    }

    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        this.builder.newResolvedDependency(resolvedConfiguration.getNodeId());
        for (DependencyGraphEdge dependency : resolvedConfiguration.getOutgoingEdges()) {
            ModuleVersionResolveException failure = dependency.getFailure();
            if (failure == null) continue;
            this.addUnresolvedDependency(dependency, dependency.getRequestedModuleVersion(), failure);
        }
    }

    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
        ResolvedConfigurationIdentifier targetNodeId = resolvedConfiguration.getNodeId();
        for (DependencyGraphEdge dependency : resolvedConfiguration.getIncomingEdges()) {
            if (dependency.getFrom().getNodeId() != this.root.getNodeId()) continue;
            ModuleDependency moduleDependency = dependency.getModuleDependency();
            this.builder.addFirstLevelDependency(moduleDependency, targetNodeId);
        }
    }

    public void visitArtifacts(ResolvedConfigurationIdentifier parent, ResolvedConfigurationIdentifier child, ArtifactSet artifacts) {
        this.builder.addChild(parent, child, artifacts.getId());
    }

    public void finish(DependencyGraphNode root) {
        this.attachFailures(this.builder);
        this.builder.done(root.getNodeId());
    }

    public void finishArtifacts() {
    }

    private void attachFailures(ResolvedConfigurationBuilder result) {
        for (Map.Entry<ModuleVersionSelector, BrokenDependency> entry : this.failuresByRevisionId.entrySet()) {
            Collection<List<ModuleVersionIdentifier>> paths = DependencyGraphPathResolver.calculatePaths(entry.getValue().requiredBy, this.root);
            result.addUnresolvedDependency(new DefaultUnresolvedDependency(entry.getKey(), (Throwable)((Object)entry.getValue().failure.withIncomingPaths(paths))));
        }
    }

    private void addUnresolvedDependency(DependencyGraphEdge dependency, ModuleVersionSelector requested, ModuleVersionResolveException failure) {
        BrokenDependency breakage = this.failuresByRevisionId.get(requested);
        if (breakage == null) {
            breakage = new BrokenDependency(failure);
            this.failuresByRevisionId.put(requested, breakage);
        }
        breakage.requiredBy.add(dependency.getFrom());
    }

    private static class BrokenDependency {
        final ModuleVersionResolveException failure;
        final List<DependencyGraphNode> requiredBy = new ArrayList<DependencyGraphNode>();

        private BrokenDependency(ModuleVersionResolveException failure) {
            this.failure = failure;
        }
    }
}

