/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PomDomParser {
    private PomDomParser() {
    }

    public static String getTextContent(Element element) {
        StringBuilder result = new StringBuilder();
        NodeList childNodes = element.getChildNodes();
        block3: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    result.append(child.getNodeValue());
                    continue block3;
                }
            }
        }
        return result.toString();
    }

    public static String getFirstChildText(Element parentElem, String name) {
        Element node = PomDomParser.getFirstChildElement(parentElem, name);
        if (node != null) {
            return PomDomParser.getTextContent(node);
        }
        return null;
    }

    public static Element getFirstChildElement(Element parentElem, String name) {
        if (parentElem == null) {
            return null;
        }
        NodeList childs = parentElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element) || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getAllChilds(Element parent) {
        LinkedList<Element> r = new LinkedList<Element>();
        if (parent != null) {
            NodeList childs = parent.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element)) continue;
                r.add((Element)node);
            }
        }
        return r;
    }

    public static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private static final int MARK = 10000;
        private static final String DOCTYPE = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n";
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        public AddDTDFilterInputStream(InputStream in) throws IOException {
            super(new BufferedInputStream(in));
            String trimmed;
            this.in.mark(10000);
            int byte1 = this.in.read();
            int byte2 = this.in.read();
            int byte3 = this.in.read();
            if (byte1 == 239 && byte2 == 187 && byte3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            int bytesToSkip = 0;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.in, "UTF-8"), 100);
            String firstLine = reader.readLine();
            if (firstLine != null && (trimmed = firstLine.trim()).startsWith("<?xml ")) {
                int endIndex = trimmed.indexOf("?>");
                String xmlDecl = trimmed.substring(0, endIndex + 2);
                this.prefix = (xmlDecl + "\n" + DOCTYPE).getBytes();
                bytesToSkip = xmlDecl.getBytes().length;
            }
            this.in.reset();
            for (int i = 0; i < bytesToSkip; ++i) {
                this.in.read();
            }
        }

        public int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            return super.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int nbrBytesCopied = 0;
            if (this.count < this.prefix.length) {
                int nbrBytesFromPrefix = Math.min(this.prefix.length - this.count, len);
                System.arraycopy(this.prefix, this.count, b, off, nbrBytesFromPrefix);
                nbrBytesCopied = nbrBytesFromPrefix;
            }
            if (nbrBytesCopied < len) {
                nbrBytesCopied += this.in.read(b, off + nbrBytesCopied, len - nbrBytesCopied);
            }
            this.count += nbrBytesCopied;
            return nbrBytesCopied;
        }
    }
}

