/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergeWriter;
import com.android.ide.common.res2.PreprocessDataItem;
import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.Callable;

public class PreprocessResourcesWriter
extends MergeWriter<PreprocessDataItem> {
    public PreprocessResourcesWriter(@NonNull File rootFolder) {
        super(rootFolder);
    }

    @Override
    public void addItem(final @NonNull PreprocessDataItem item) throws MergeConsumer.ConsumerException {
        if (!item.isTouched()) {
            return;
        }
        this.getExecutor().execute(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                File destination = new File(PreprocessResourcesWriter.this.getRootFolder(), item.getName());
                Files.createParentDirs((File)destination);
                Files.copy((File)item.getFileToUse(), (File)destination);
                return null;
            }
        });
    }

    @Override
    public void removeItem(@NonNull PreprocessDataItem removedItem, @Nullable PreprocessDataItem replacedBy) throws MergeConsumer.ConsumerException {
        if (replacedBy == null) {
            File removedFile = new File(this.getRootFolder(), removedItem.getName());
            removedFile.delete();
        }
    }

    @Override
    public boolean ignoreItemInMerge(PreprocessDataItem item) {
        return false;
    }
}

