/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Warning
implements Comparable<Warning> {
    public final Issue issue;
    public final String message;
    public final Severity severity;
    public final Project project;
    public AndroidProject gradleProject;
    public Location location;
    public File file;
    public String path;
    public int line = -1;
    public int offset = -1;
    public String errorLine;
    public String fileContents;
    public Set<Variant> variants;

    public Warning(Issue issue, String message, Severity severity, Project project) {
        this.issue = issue;
        this.message = message;
        this.severity = severity;
        this.project = project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Warning other) {
        File secondaryFile2;
        int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
        if (categoryDelta != 0) {
            return categoryDelta;
        }
        int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
        if (priorityDelta != 0) {
            return priorityDelta;
        }
        String id1 = this.issue.getId();
        String id2 = other.issue.getId();
        assert (id1 != null);
        assert (id2 != null);
        int idDelta = id1.compareTo(id2);
        if (idDelta != 0) {
            return idDelta;
        }
        if (this.file != null) {
            if (other.file == null) return -1;
            int fileDelta = this.file.getName().compareTo(other.file.getName());
            if (fileDelta != 0) {
                return fileDelta;
            }
        } else if (other.file != null) {
            return 1;
        }
        if (this.line != other.line) {
            return this.line - other.line;
        }
        int delta = this.message.compareTo(other.message);
        if (delta != 0) {
            return delta;
        }
        if (this.file != null) {
            if (other.file == null) return -1;
            delta = this.file.compareTo(other.file);
            if (delta != 0) {
                return delta;
            }
        } else if (other.file != null) {
            return 1;
        }
        Location secondary1 = this.location != null ? this.location.getSecondary() : null;
        File secondaryFile1 = secondary1 != null ? secondary1.getFile() : null;
        Location secondary2 = other.location != null ? other.location.getSecondary() : null;
        File file = secondaryFile2 = secondary2 != null ? secondary2.getFile() : null;
        if (secondaryFile1 != null) {
            if (secondaryFile2 == null) return -1;
            return secondaryFile1.compareTo(secondaryFile2);
        }
        if (secondaryFile2 != null) {
            return 1;
        }
        if (this.location == null || other.location == null || this.location.getStart() == null || other.location.getStart() == null || (delta = this.location.getStart().getColumn() - other.location.getStart().getColumn()) == 0) return 0;
        return delta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Location secondary2;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        if (this.line != warning.line) {
            return false;
        }
        if (this.file != null ? !this.file.equals(warning.file) : warning.file != null) {
            return false;
        }
        if (!this.issue.getCategory().equals((Object)warning.issue.getCategory())) {
            return false;
        }
        if (this.issue.getPriority() != warning.issue.getPriority()) {
            return false;
        }
        if (!this.issue.getId().equals(warning.issue.getId())) {
            return false;
        }
        if (!this.message.equals(warning.message)) {
            return false;
        }
        Location secondary1 = this.location != null ? this.location.getSecondary() : null;
        Location location = secondary2 = warning.location != null ? warning.location.getSecondary() : null;
        if (secondary1 != null) {
            if (secondary2 == null) return false;
            if (Objects.equal((Object)secondary1.getFile(), (Object)secondary2.getFile())) return this.location == null || warning.location == null || this.location.getStart() == null || warning.location.getStart() == null || this.location.getStart().getColumn() == warning.location.getStart().getColumn();
            return false;
        }
        if (secondary2 == null) return this.location == null || warning.location == null || this.location.getStart() == null || warning.location.getStart() == null || this.location.getStart().getColumn() == warning.location.getStart().getColumn();
        return false;
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        return result;
    }

    public boolean isVariantSpecific() {
        return this.variants != null && this.variants.size() < this.gradleProject.getVariants().size();
    }

    public boolean includesMoreThanExcludes() {
        int allVariantCount;
        assert (this.isVariantSpecific());
        int variantCount = this.variants.size();
        return variantCount <= (allVariantCount = this.gradleProject.getVariants().size()) - variantCount;
    }

    public List<String> getIncludedVariantNames() {
        assert (this.isVariantSpecific());
        ArrayList<String> names = new ArrayList<String>();
        if (this.variants != null) {
            for (Variant variant : this.variants) {
                names.add(variant.getName());
            }
        }
        Collections.sort(names);
        return names;
    }

    public List<String> getExcludedVariantNames() {
        assert (this.isVariantSpecific());
        Collection variants = this.gradleProject.getVariants();
        HashSet<String> allVariants = new HashSet<String>(variants.size());
        for (Variant variant : variants) {
            allVariants.add(variant.getName());
        }
        HashSet<String> included = new HashSet<String>(this.getIncludedVariantNames());
        Sets.SetView excluded = Sets.difference(allVariants, included);
        ArrayList sorted = Lists.newArrayList((Iterable)excluded);
        Collections.sort(sorted);
        return sorted;
    }

    public String toString() {
        return "Warning{issue=" + this.issue + ", message='" + this.message + '\'' + ", file=" + this.file + ", line=" + this.line + '}';
    }
}

