/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.gradleplugin.userinterface.swing.common.BorderlessImageButton;
import org.gradle.gradleplugin.userinterface.swing.common.BorderlessImageToggleButton;

public class Utility {
    private static final Logger LOGGER = Logging.getLogger(Utility.class);

    public static Component addLeftJustifiedComponent(Component component) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(component);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public static Component addRightJustifiedComponent(Component component) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(component);
        return panel;
    }

    public static JDialog createDialog(Window parent, String title, boolean isModal) {
        if (parent instanceof JDialog) {
            return new JDialog((JDialog)parent, title, isModal);
        }
        if (parent instanceof JFrame) {
            return new JDialog((JFrame)parent, title, isModal);
        }
        throw new RuntimeException("Unknown window type!");
    }

    public static void setTabComponent15Compatible(JTabbedPane tabbedPane, int index, Component component) {
        try {
            Method method = tabbedPane.getClass().getMethod("setTabComponentAt", Integer.TYPE, Component.class);
            method.invoke((Object)tabbedPane, index, component);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            LOGGER.error("Setting tab component", (Throwable)e);
        }
    }

    public static JButton createButton(Class resourceClass, String imageResourceName, String tooltip, Action action) {
        InputStream inputStream;
        JButton button = null;
        if (imageResourceName != null && (inputStream = resourceClass.getResourceAsStream(imageResourceName)) != null) {
            try {
                BufferedImage image = ImageIO.read(inputStream);
                button = new BorderlessImageButton(action, (Icon)new ImageIcon(image));
            }
            catch (IOException e) {
                LOGGER.error("Reading image " + imageResourceName, (Throwable)e);
            }
        }
        if (button == null) {
            button = new JButton(action);
        }
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public static JToggleButton createToggleButton(Class resourceClass, String imageResourceName, String tooltip, Action action) {
        ImageIcon icon;
        JToggleButton button = null;
        if (imageResourceName != null && (icon = Utility.getImageIcon(resourceClass, imageResourceName)) != null) {
            button = new BorderlessImageToggleButton(action, (Icon)icon);
        }
        if (button == null) {
            button = new JToggleButton(action);
        }
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public static JMenuItem createMenuItem(Class resourceClass, String name, String imageResourceName, Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setText(name);
        if (imageResourceName != null) {
            ImageIcon icon = Utility.getImageIcon(resourceClass, imageResourceName);
            item.setIcon(icon);
        }
        return item;
    }

    public static boolean isCTRLDown(int eventModifiersEx) {
        return (eventModifiersEx & 0x80) == 128;
    }

    public static ImageIcon getImageIcon(Class resourceClass, String imageResourceName) {
        InputStream inputStream = resourceClass.getResourceAsStream(imageResourceName);
        if (inputStream != null) {
            try {
                BufferedImage image = ImageIO.read(inputStream);
                return new ImageIcon(image);
            }
            catch (IOException e) {
                LOGGER.error("Reading image " + imageResourceName, (Throwable)e);
            }
        }
        return null;
    }

    public static void scrollToText(JTextComponent textComponent, int startingIndex, int endingIndex) {
        try {
            Rectangle startingRectangle = textComponent.modelToView(startingIndex);
            Rectangle endDingRectangle = textComponent.modelToView(endingIndex);
            Rectangle totalBounds = startingRectangle.union(endDingRectangle);
            textComponent.scrollRectToVisible(totalBounds);
            textComponent.repaint();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

