/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.gradle.foundation.TaskView;
import org.gradle.gradleplugin.foundation.favorites.FavoritesEditor;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingAddMultipleFavoritesInteraction
implements FavoritesEditor.AddMultipleFavoritesInteraction {
    private Window parent;

    public SwingAddMultipleFavoritesInteraction(Window parent) {
        this.parent = parent;
    }

    @Override
    public FavoritesEditor.AddMultipleResult promptUserToCombineTasks(List<TaskView> tasksSample, String singleCommandSample) {
        PromptToCombineTasksDialog dialog = new PromptToCombineTasksDialog();
        return dialog.show(this.parent, tasksSample, singleCommandSample);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PromptToCombineTasksDialog {
        private JDialog dialog;
        private FavoritesEditor.AddMultipleResult addMultipleResult;
        private JRadioButton separatelyRadioButton;
        private JRadioButton combinedRadioButton;
        private ButtonGroup buttonGroup;
        private JLabel separateLine1;
        private JLabel separateLine2;
        private JLabel separateLine3;
        private JLabel combinedLine1;

        public FavoritesEditor.AddMultipleResult show(Window parent, List<TaskView> tasksSample, String singleCommandSample) {
            this.setupUI(parent);
            this.populateValues(tasksSample, singleCommandSample);
            this.dialog.setVisible(true);
            return this.addMultipleResult;
        }

        private void populateValues(List<TaskView> tasksSample, String singleCommandSample) {
            this.separatelyRadioButton.setText("Add as separate " + tasksSample.size() + " commands:");
            this.separateLine1.setText('\"' + tasksSample.get(0).getFullTaskName() + "\",");
            String secondTask = '\"' + tasksSample.get(1).getFullTaskName() + "\"";
            String thirdTask = "";
            if (tasksSample.size() > 2) {
                secondTask = secondTask + ",";
                thirdTask = '\"' + tasksSample.get(2).getFullTaskName() + "\"";
                if (tasksSample.size() > 3) {
                    thirdTask = thirdTask + ", ... ";
                }
            }
            this.separateLine2.setText(secondTask);
            this.separateLine3.setText(thirdTask);
            this.separateLine3.setVisible(tasksSample.size() > 2);
            this.combinedLine1.setText('\"' + singleCommandSample + '\"');
        }

        private void setupUI(Window parent) {
            this.dialog = Utility.createDialog(parent, "Add Multiple Tasks", true);
            this.dialog.setSize(400, 350);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PromptToCombineTasksDialog.this.close(FavoritesEditor.AddMultipleResult.Cancel);
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add(panel);
            panel.add(this.createMainPanel(), "Center");
            panel.add(this.createButtonPanel(), "South");
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.dialog.setLocationRelativeTo(this.dialog.getParent());
        }

        private Component createMainPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            this.separatelyRadioButton = new JRadioButton();
            this.combinedRadioButton = new JRadioButton("Add as a single command:");
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.separatelyRadioButton);
            this.buttonGroup.add(this.combinedRadioButton);
            this.separatelyRadioButton.setSelected(true);
            panel.add(Utility.addLeftJustifiedComponent(new JLabel("How you do want to add multiple tasks?")));
            panel.add(Box.createVerticalStrut(20));
            panel.add(Utility.addLeftJustifiedComponent(this.separatelyRadioButton));
            panel.add(Box.createVerticalStrut(5));
            panel.add(this.createSeparateSamplePanel());
            panel.add(Box.createVerticalStrut(20));
            panel.add(Utility.addLeftJustifiedComponent(this.combinedRadioButton));
            panel.add(Box.createVerticalStrut(5));
            panel.add(this.createCombinedSamplePanel());
            panel.add(Box.createVerticalGlue());
            return panel;
        }

        private JPanel createSeparateSamplePanel() {
            this.separateLine1 = new JLabel();
            this.separateLine2 = new JLabel();
            this.separateLine3 = new JLabel();
            JPanel separateSamplePanel = new JPanel();
            separateSamplePanel.setLayout(new BoxLayout(separateSamplePanel, 1));
            separateSamplePanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            separateSamplePanel.add(Utility.addLeftJustifiedComponent(this.separateLine1));
            separateSamplePanel.add(Utility.addLeftJustifiedComponent(this.separateLine2));
            separateSamplePanel.add(Utility.addLeftJustifiedComponent(this.separateLine3));
            return separateSamplePanel;
        }

        private JPanel createCombinedSamplePanel() {
            this.combinedLine1 = new JLabel();
            JPanel combinedSamplePanel = new JPanel();
            combinedSamplePanel.setLayout(new BoxLayout(combinedSamplePanel, 1));
            combinedSamplePanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            combinedSamplePanel.add(Utility.addLeftJustifiedComponent(this.combinedLine1));
            return combinedSamplePanel;
        }

        private FavoritesEditor.AddMultipleResult getCurrentSelection() {
            if (this.separatelyRadioButton.isSelected()) {
                return FavoritesEditor.AddMultipleResult.AddSeparately;
            }
            return FavoritesEditor.AddMultipleResult.AddAsSingleCommand;
        }

        private Component createButtonPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            JButton okButton = new JButton(new AbstractAction("OK"){

                public void actionPerformed(ActionEvent e) {
                    PromptToCombineTasksDialog.this.close(PromptToCombineTasksDialog.this.getCurrentSelection());
                }
            });
            this.dialog.getRootPane().setDefaultButton(okButton);
            JButton cancelButton = new JButton(new AbstractAction("Cancel"){

                public void actionPerformed(ActionEvent e) {
                    PromptToCombineTasksDialog.this.close(FavoritesEditor.AddMultipleResult.Cancel);
                }
            });
            this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PromptToCombineTasksDialog.this.close(FavoritesEditor.AddMultipleResult.Cancel);
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
            panel.add(Box.createHorizontalGlue());
            panel.add(okButton);
            panel.add(Box.createHorizontalStrut(10));
            panel.add(cancelButton);
            panel.add(Box.createHorizontalGlue());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            return panel;
        }

        private void close(FavoritesEditor.AddMultipleResult addMultipleResult) {
            this.addMultipleResult = addMultipleResult;
            this.dialog.setVisible(false);
        }
    }
}

