/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.gradleplugin.foundation.search.BasicTextSearchCriteria;
import org.gradle.gradleplugin.foundation.search.TextBlockSearchEditor;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;

public class SearchPanel {
    private final Logger logger = Logging.getLogger(SearchPanel.class);
    private JPanel mainPanel;
    private JTextField textToMatchField;
    private JCheckBox isCaseSensitiveCheckBox;
    private JCheckBox useRegularExpressionsCheckBox;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private SearchInteraction searchInteraction;
    private TextBlockSearchEditor editor = new TextBlockSearchEditor();
    private Color notFoundColor = Color.red.brighter();
    private volatile LinkedBlockingQueue<SearchRequest> searchRequests = new LinkedBlockingQueue();
    private ExecutorService executorService;

    public SearchPanel(SearchInteraction searchInteraction) {
        this.searchInteraction = searchInteraction;
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(new SearchTask());
        this.setupUI();
        this.hide();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void setupUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
        this.isCaseSensitiveCheckBox = new JCheckBox("Case Sensitive");
        this.isCaseSensitiveCheckBox.setMnemonic('c');
        this.isCaseSensitiveCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.requestSearch();
            }
        });
        this.useRegularExpressionsCheckBox = new JCheckBox("Regular Expression");
        this.useRegularExpressionsCheckBox.setMnemonic('r');
        this.useRegularExpressionsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.requestSearch();
            }
        });
        this.findNextButton = Utility.createButton(this.getClass(), "/org/gradle/gradleplugin/userinterface/swing/generic/tabs/move-down.png", "Find Next Match", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.goToNextMatch();
            }
        });
        this.findPreviousButton = Utility.createButton(this.getClass(), "/org/gradle/gradleplugin/userinterface/swing/generic/tabs/move-up.png", "Find Previous Match", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.goToPreviousMatch();
            }
        });
        JButton closeButton = Utility.createButton(this.getClass(), "/org/gradle/gradleplugin/userinterface/swing/generic/close.png", "Close Search Panel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.hide();
            }
        });
        this.mainPanel.add(this.createTextToMatchField());
        this.mainPanel.add(Box.createHorizontalStrut(5));
        this.mainPanel.add(this.findPreviousButton);
        this.mainPanel.add(Box.createHorizontalStrut(5));
        this.mainPanel.add(this.findNextButton);
        this.mainPanel.add(Box.createHorizontalStrut(5));
        this.mainPanel.add(this.isCaseSensitiveCheckBox);
        this.mainPanel.add(Box.createHorizontalStrut(5));
        this.mainPanel.add(this.useRegularExpressionsCheckBox);
        this.addAdditionalFields(this.mainPanel);
        this.mainPanel.add(Box.createHorizontalGlue());
        this.mainPanel.add(closeButton);
    }

    private Component createTextToMatchField() {
        this.textToMatchField = new JTextField();
        this.textToMatchField.setMinimumSize(new Dimension(50, 10));
        this.textToMatchField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.hide();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        ActionListener performSearchNextAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.goToNextMatch();
            }
        };
        ActionListener performSearchPreviousAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.goToPreviousMatch();
            }
        };
        this.textToMatchField.registerKeyboardAction(performSearchNextAction, KeyStroke.getKeyStroke(10, 0), 2);
        this.textToMatchField.registerKeyboardAction(performSearchNextAction, KeyStroke.getKeyStroke(114, 0), 2);
        this.textToMatchField.registerKeyboardAction(performSearchPreviousAction, KeyStroke.getKeyStroke(114, 1), 2);
        this.textToMatchField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SearchPanel.this.requestSearch();
            }

            public void removeUpdate(DocumentEvent e) {
                SearchPanel.this.requestSearch();
            }

            public void changedUpdate(DocumentEvent e) {
                SearchPanel.this.requestSearch();
            }
        });
        return this.textToMatchField;
    }

    private void requestSearch() {
        String textToMatch = this.textToMatchField.getText();
        boolean isCaseSensitive = this.isCaseSensitiveCheckBox.isSelected();
        boolean useRegularExpressions = this.useRegularExpressionsCheckBox.isSelected();
        String textToSearch = this.searchInteraction.getTextToSearch();
        this.searchRequests.offer(new SearchRequest(textToMatch, isCaseSensitive, useRegularExpressions, textToSearch));
    }

    private SearchRequest getNextAvailableRequest() {
        try {
            SearchRequest searchRequest = this.searchRequests.take();
            if (this.searchRequests.size() > 1) {
                ArrayList tasks = new ArrayList();
                this.searchRequests.drainTo(tasks);
                if (!tasks.isEmpty()) {
                    searchRequest = (SearchRequest)tasks.get(tasks.size() - 1);
                }
            }
            return searchRequest;
        }
        catch (Exception e) {
            this.logger.error("Getting next available request", (Throwable)e);
            return null;
        }
    }

    public void performSearchAgain() {
        if (this.mainPanel.isVisible()) {
            this.requestSearch();
        }
    }

    private void goToNextMatch() {
        TextBlockSearchEditor.SearchResult searchResult = this.editor.getNextSearchResult(this.searchInteraction.getCaretLocation());
        if (searchResult != null) {
            this.searchInteraction.highlightAndScrollToResult(this.editor, searchResult);
        }
    }

    private void goToPreviousMatch() {
        TextBlockSearchEditor.SearchResult searchResult = this.editor.getPreviousSearchResult(this.searchInteraction.getCaretLocation());
        if (searchResult != null) {
            this.searchInteraction.highlightAndScrollToResult(this.editor, searchResult);
        }
    }

    protected void addAdditionalFields(JPanel panel) {
    }

    public void hide() {
        if (this.searchInteraction != null) {
            this.searchInteraction.removeResultHighlights();
        }
        this.mainPanel.setVisible(false);
    }

    public void show() {
        this.mainPanel.setVisible(true);
        this.showNormalColor();
        this.textToMatchField.selectAll();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchPanel.this.textToMatchField.requestFocus();
            }
        });
        this.requestSearch();
    }

    private void showNormalColor() {
        this.textToMatchField.setForeground(UIManager.getColor("TextArea.foreground"));
    }

    private void showNoMatchColor() {
        this.textToMatchField.setForeground(this.notFoundColor);
    }

    public void enableButtonsAndFieldsAppropriately(boolean foundAMatch) {
        if (foundAMatch) {
            this.showNormalColor();
        } else {
            this.showNoMatchColor();
        }
        this.findNextButton.setEnabled(foundAMatch);
        this.findPreviousButton.setEnabled(foundAMatch);
    }

    private class SearchTask
    implements Runnable {
        private BasicTextSearchCriteria criteria = new BasicTextSearchCriteria();

        private SearchTask() {
        }

        public void run() {
            while (true) {
                SearchRequest request;
                if ((request = SearchPanel.this.getNextAvailableRequest()) == null) {
                    continue;
                }
                this.criteria.setTextToMatch(request.textToMatch);
                this.criteria.setCaseSensitive(request.isCaseSensitive);
                this.criteria.setUseRegularExpressions(request.useRegularExpressions);
                SearchPanel.this.editor.searchAllText(request.textToSearch, this.criteria);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchPanel.this.searchInteraction.searchComplete(SearchPanel.this.editor);
                        SearchPanel.this.enableButtonsAndFieldsAppropriately(SearchPanel.this.editor.hasMatches());
                    }
                });
            }
        }
    }

    private class SearchRequest {
        private String textToMatch;
        private boolean isCaseSensitive;
        private boolean useRegularExpressions;
        private String textToSearch;

        private SearchRequest(String textToMatch, boolean caseSensitive, boolean useRegularExpressions, String textToSearch) {
            this.textToMatch = textToMatch;
            this.isCaseSensitive = caseSensitive;
            this.useRegularExpressions = useRegularExpressions;
            this.textToSearch = textToSearch;
        }

        public String toString() {
            return "textToMatch='" + this.textToMatch + '\'' + ", isCaseSensitive=" + this.isCaseSensitive + ", useRegularExpressions=" + this.useRegularExpressions;
        }
    }

    public static interface SearchInteraction {
        public String getTextToSearch();

        public int getCaretLocation();

        public void highlightAndScrollToResult(TextBlockSearchEditor var1, TextBlockSearchEditor.SearchResult var2);

        public void searchComplete(TextBlockSearchEditor var1);

        public void removeResultHighlights();
    }
}

