/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.request;

import org.gradle.foundation.ipc.basic.ProcessLauncherServer;
import org.gradle.foundation.ipc.gradle.ExecuteGradleCommandServerProtocol;
import org.gradle.foundation.queue.ExecutionQueue;
import org.gradle.gradleplugin.foundation.request.Request;

public abstract class AbstractRequest
implements Request {
    private long requestID;
    private String fullCommandLine;
    private String displayName;
    private boolean forceOutputToBeShown;
    private ExecutionQueue.RequestCancellation cancellation;
    private ProcessLauncherServer server;
    protected ExecuteGradleCommandServerProtocol.ExecutionInteraction executionInteraction = new DummyExecutionInteraction();

    public AbstractRequest(long requestID, String fullCommandLine, String displayName, boolean forceOutputToBeShown, ExecutionQueue.RequestCancellation cancellation) {
        this.requestID = requestID;
        this.fullCommandLine = fullCommandLine;
        this.displayName = displayName;
        this.forceOutputToBeShown = forceOutputToBeShown;
        this.cancellation = cancellation;
    }

    public long getRequestID() {
        return this.requestID;
    }

    public String getFullCommandLine() {
        return this.fullCommandLine;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean forceOutputToBeShown() {
        return this.forceOutputToBeShown;
    }

    public synchronized boolean cancel() {
        if (this.server != null) {
            this.server.killProcess();
        }
        this.cancellation.onCancel(this);
        return true;
    }

    public synchronized void setProcessLauncherServer(ProcessLauncherServer server) {
        this.server = server;
    }

    public void setExecutionInteraction(ExecuteGradleCommandServerProtocol.ExecutionInteraction executionInteraction) {
        this.executionInteraction = executionInteraction;
    }

    public class DummyExecutionInteraction
    implements ExecuteGradleCommandServerProtocol.ExecutionInteraction {
        public void reportExecutionStarted() {
        }

        public void reportNumberOfTasksToExecute(int size) {
        }

        public void reportExecutionFinished(boolean wasSuccessful, String message, Throwable throwable) {
        }

        public void reportTaskStarted(String message, float percentComplete) {
        }

        public void reportTaskComplete(String message, float percentComplete) {
        }

        public void reportLiveOutput(String message) {
        }
    }
}

