/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;

public class LeakDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"StaticFieldLeak", (String)"Static Field Leaks", (String)"A static field will leak contexts.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(LeakDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiField.class);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new FieldChecker(context);
    }

    private static boolean isLeakCandidate(PsiClass cls, JavaEvaluator evaluator) {
        return evaluator.extendsClass(cls, "android.content.Context", false) || evaluator.extendsClass(cls, "android.view.View", false) || evaluator.extendsClass(cls, "android.app.Fragment", false);
    }

    private static class FieldChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public FieldChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitField(PsiField field) {
            block6: {
                PsiClass cls;
                String fqn;
                PsiModifierList modifierList;
                block5: {
                    modifierList = field.getModifierList();
                    if (modifierList == null || !modifierList.hasModifierProperty("static")) {
                        return;
                    }
                    PsiType type = field.getType();
                    if (!(type instanceof PsiClassType)) {
                        return;
                    }
                    fqn = type.getCanonicalText();
                    if (fqn.startsWith("java.")) {
                        return;
                    }
                    cls = ((PsiClassType)type).resolve();
                    if (cls == null) {
                        return;
                    }
                    if (!fqn.startsWith("android.")) break block5;
                    if (!LeakDetector.isLeakCandidate(cls, this.mContext.getEvaluator())) break block6;
                    String message = "Do not place Android context classes in static fields; this is a memory leak (and also breaks Instant Run)";
                    this.report(field, modifierList, message);
                    break block6;
                }
                int count = 0;
                for (PsiField referenced : cls.getAllFields()) {
                    PsiClass innerCls;
                    if (count++ == 20) break;
                    PsiType innerType = referenced.getType();
                    if (!(innerType instanceof PsiClassType) || (fqn = innerType.getCanonicalText()).startsWith("java.") || (innerCls = ((PsiClassType)innerType).resolve()) == null || !fqn.startsWith("android.") || !LeakDetector.isLeakCandidate(innerCls, this.mContext.getEvaluator())) continue;
                    String message = "Do not place Android context classes in static fields (static reference to `" + cls.getName() + "` which has field " + "`" + referenced.getName() + "` pointing to `" + innerCls.getName() + "`); " + "this is a memory leak (and also breaks Instant Run)";
                    this.report(field, modifierList, message);
                    break;
                }
            }
        }

        private void report(PsiField field, PsiModifierList modifierList, String message) {
            Location location = this.mContext.getLocation((PsiElement)(modifierList.getTextRange().getLength() > 0 ? modifierList : field));
            this.mContext.report(ISSUE, (PsiElement)field, location, message);
        }
    }
}

