/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import com.appspot.cluestick_server.search.model.Result;
import com.google.devrel.cluestick.studioclient.IconFetcher;
import com.google.devrel.cluestick.studioclient.SearchResultsView;
import com.google.devrel.cluestick.studioclient.Symbol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import javax.swing.JComponent;

public class DynamicToolWindowWrapper {
    private static final String TOOL_WINDOW_TAG = "Find Sample Code";
    private Project project;
    private ToolWindow toolWindow;

    public DynamicToolWindowWrapper(Project project) {
        this.project = project;
    }

    public static DynamicToolWindowWrapper getInstance(Project project) {
        return (DynamicToolWindowWrapper)ServiceManager.getService((Project)project, DynamicToolWindowWrapper.class);
    }

    public ToolWindow getToolWindow(Symbol symbol, List<Result> results) {
        if (this.toolWindow == null) {
            this.toolWindow = ToolWindowManager.getInstance((Project)this.project).registerToolWindow(TOOL_WINDOW_TAG, true, ToolWindowAnchor.BOTTOM);
            this.toolWindow.setIcon(IconFetcher.GoogleDevelopers);
        }
        this.toolWindow.show(null);
        SearchResultsView view = new SearchResultsView(this.project, symbol, results);
        view.setClose(new Runnable(){

            @Override
            public void run() {
                DynamicToolWindowWrapper.this.toolWindow.hide(null);
            }
        });
        String title = "";
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title, false);
        content.setDisposer((Disposable)view);
        content.setShouldDisposeContent(false);
        ContentManager contentManager = this.toolWindow.getContentManager();
        contentManager.removeAllContents(true);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        return this.toolWindow;
    }
}

