/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;

public class JpsPathVariablesConfigurationImpl
extends JpsElementBase<JpsPathVariablesConfigurationImpl>
implements JpsPathVariablesConfiguration {
    private Map<String, String> myPathVariables;

    public JpsPathVariablesConfigurationImpl() {
        this.myPathVariables = new LinkedHashMap<String, String>();
    }

    private JpsPathVariablesConfigurationImpl(Map<String, String> pathVariables) {
        this.myPathVariables = new LinkedHashMap<String, String>(pathVariables);
    }

    @NotNull
    public JpsPathVariablesConfigurationImpl createCopy() {
        return new JpsPathVariablesConfigurationImpl(this.myPathVariables);
    }

    public void applyChanges(@NotNull JpsPathVariablesConfigurationImpl modified) {
    }

    @Override
    public void addPathVariable(@NotNull String name, @NotNull String value) {
        this.myPathVariables.put(name, value);
    }

    @Override
    public void removePathVariable(@NotNull String name) {
        this.myPathVariables.remove(name);
    }

    @Override
    @Nullable
    public String getPathVariable(@NotNull String name) {
        return this.getUserVariableValue(name);
    }

    @Override
    @Nullable
    public String getUserVariableValue(@NotNull String name) {
        return this.myPathVariables.get(name);
    }

    @Override
    @NotNull
    public Map<String, String> getAllVariables() {
        return this.getAllUserVariables();
    }

    @Override
    @NotNull
    public Map<String, String> getAllUserVariables() {
        return Collections.unmodifiableMap(this.myPathVariables);
    }
}

