/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.facet;

import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;

public class JpsFacetSerializer {
    @NonNls
    public static final String FACET_TAG = "facet";
    @NonNls
    public static final String TYPE_ATTRIBUTE = "type";
    @NonNls
    public static final String CONFIGURATION_TAG = "configuration";
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";

    public static void loadFacets(JpsModule module, @Nullable Element facetManagerElement) {
        if (facetManagerElement == null) {
            return;
        }
        FacetManagerState state = (FacetManagerState)XmlSerializer.deserialize((Element)facetManagerElement, FacetManagerState.class);
        if (state != null) {
            JpsFacetSerializer.addFacets(module, state.getFacets(), null);
        }
    }

    public static void saveFacets(JpsModule module, @NotNull Element facetManagerElement) {
        FacetManagerState managerState = new FacetManagerState();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsFacetConfigurationSerializer<?> serializer : extension.getFacetConfigurationSerializers()) {
                if (!serializer.hasExtension(module)) continue;
                serializer.saveExtension(module, managerState.getFacets());
            }
        }
        XmlSerializer.serializeInto((Object)managerState, (Element)facetManagerElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    private static void addFacets(JpsModule module, List<FacetState> facets, @Nullable JpsElement parentFacet) {
        for (FacetState facetState : facets) {
            JpsFacetConfigurationSerializer<?> serializer = JpsFacetSerializer.getModuleExtensionSerializer(facetState.getFacetType());
            if (serializer == null) continue;
            Object element = JpsFacetSerializer.addExtension(module, serializer, facetState, parentFacet);
            JpsFacetSerializer.addFacets(module, facetState.getSubFacets(), element);
        }
    }

    private static <E extends JpsElement> E addExtension(JpsModule module, JpsFacetConfigurationSerializer<E> serializer, FacetState facet, JpsElement parentFacet) {
        return serializer.loadExtension(facet.getConfiguration(), facet.getName(), module, parentFacet);
    }

    @Nullable
    private static JpsFacetConfigurationSerializer<?> getModuleExtensionSerializer(@NotNull String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsFacetConfigurationSerializer<?> serializer : extension.getFacetConfigurationSerializers()) {
                if (!serializer.getFacetTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return null;
    }

    public static JpsModuleReference createModuleReference(String facetId) {
        String moduleName = facetId.substring(0, facetId.indexOf(47));
        return JpsElementFactory.getInstance().createModuleReference(moduleName);
    }

    public static String getFacetId(JpsModuleReference moduleReference, String facetTypeId, String facetName) {
        return moduleReference.getModuleName() + "/" + facetTypeId + "/" + facetName;
    }
}

