/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl.sdk;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsSdkImpl<P extends JpsElement>
extends JpsCompositeElementBase<JpsSdkImpl<P>>
implements JpsSdk<P> {
    private final JpsSdkType<P> mySdkType;
    private String myHomePath;
    private String myVersionString;

    public JpsSdkImpl(String homePath, String versionString, JpsSdkType<P> type, P properties) {
        this.myHomePath = homePath;
        this.myVersionString = versionString;
        this.mySdkType = type;
        this.myContainer.setChild(type.getSdkPropertiesRole(), properties);
    }

    private JpsSdkImpl(JpsSdkImpl<P> original) {
        super(original);
        this.mySdkType = original.mySdkType;
        this.myHomePath = original.myHomePath;
        this.myVersionString = original.myVersionString;
    }

    @NotNull
    public JpsSdkImpl<P> createCopy() {
        return new JpsSdkImpl<P>(this);
    }

    public P getSdkProperties() {
        return (P)this.myContainer.getChild(this.mySdkType.getSdkPropertiesRole());
    }

    public JpsSdkReference<P> createReference() {
        return JpsElementFactory.getInstance().createSdkReference(this.getParent().getName(), this.mySdkType);
    }

    public JpsSdkType<P> getSdkType() {
        return this.mySdkType;
    }

    @NotNull
    public JpsLibraryImpl<JpsSdk<P>> getParent() {
        return (JpsLibraryImpl)super.getParent();
    }

    public void applyChanges(@NotNull JpsSdkImpl<P> modified) {
        super.applyChanges(modified);
        this.setHomePath(modified.getHomePath());
        this.setVersionString(modified.getVersionString());
    }

    public String getHomePath() {
        return this.myHomePath;
    }

    public void setHomePath(String homePath) {
        if (!Comparing.equal((String)this.myHomePath, (String)homePath)) {
            this.myHomePath = homePath;
            this.fireElementChanged();
        }
    }

    public String getVersionString() {
        return this.myVersionString;
    }

    public void setVersionString(String versionString) {
        if (!Comparing.equal((String)this.myVersionString, (String)versionString)) {
            this.myVersionString = versionString;
            this.fireElementChanged();
        }
    }
}

