/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.util.xmlb.XmlSerializer;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.groovy.GreclipseJpsCompilerSettings;
import org.jetbrains.jps.incremental.groovy.GreclipseSettings;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class GroovyModelSerializerExtension
extends JpsModelSerializerExtension {
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        return Arrays.asList(new JpsProjectExtensionSerializer[]{new JpsProjectExtensionSerializer("groovyc.xml", "GroovyCompilerProjectConfiguration"){

            public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
                JpsGroovySettings configuration = (JpsGroovySettings)((Object)XmlSerializer.deserialize((Element)componentTag, JpsGroovySettings.class));
                if (configuration == null) {
                    configuration = new JpsGroovySettings();
                }
                configuration.initExcludes();
                project.getContainer().setChild(JpsGroovySettings.ROLE, (JpsElement)configuration);
            }

            public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            }
        }, new GreclipseSettingsSerializer()});
    }

    private static class GreclipseSettingsSerializer
    extends JpsProjectExtensionSerializer {
        private GreclipseSettingsSerializer() {
            super("compiler.xml", "GreclipseSettings");
        }

        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            GreclipseSettings settings = (GreclipseSettings)XmlSerializer.deserialize((Element)componentTag, GreclipseSettings.class);
            if (settings == null) {
                settings = new GreclipseSettings();
            }
            GreclipseJpsCompilerSettings component = new GreclipseJpsCompilerSettings(settings);
            project.getContainer().setChild(GreclipseJpsCompilerSettings.ROLE, (JpsElement)component);
        }

        public void loadExtensionWithDefaultSettings(@NotNull JpsProject project) {
            GreclipseJpsCompilerSettings component = new GreclipseJpsCompilerSettings(new GreclipseSettings());
            project.getContainer().setChild(GreclipseJpsCompilerSettings.ROLE, (JpsElement)component);
        }

        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        }
    }
}

