/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.GroovyRtConstants;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.groovy.ForkedGroovyc;
import org.jetbrains.jps.incremental.groovy.GreclipseBuilder;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.InProcessGroovyc;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class GroovyBuilder
extends ModuleLevelBuilder {
    private static final int ourOptimizeThreshold = Integer.parseInt(System.getProperty("groovyc.optimized.class.loading.threshold", "10"));
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GroovyBuilder");
    private static final Key<Boolean> CHUNK_REBUILD_ORDERED = Key.create((String)"CHUNK_REBUILD_ORDERED");
    private static final Key<Map<String, String>> STUB_TO_SRC = Key.create((String)"STUB_TO_SRC");
    private static final Key<Map<ModuleChunk, GroovycContinuation>> CONTINUATIONS = Key.create((String)"CONTINUATIONS");
    private static final Key<Boolean> FILES_MARKED_DIRTY_FOR_NEXT_ROUND = Key.create((String)"SRC_MARKED_DIRTY");
    private static final String GROOVY_EXTENSION = "groovy";
    private final boolean myForStubs;
    private final String myBuilderName;

    public GroovyBuilder(boolean forStubs) {
        super(forStubs ? BuilderCategory.SOURCE_GENERATOR : BuilderCategory.OVERWRITING_TRANSLATOR);
        this.myForStubs = forStubs;
        this.myBuilderName = "Groovy " + (forStubs ? "stub generator" : "compiler");
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException {
        if (GreclipseBuilder.useGreclipse(context)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        long start = 0L;
        try {
            Map<ModuleBuildTarget, String> finalOutputs;
            JpsGroovySettings settings = JpsGroovySettings.getSettings(context.getProjectDescriptor().getProject());
            Ref hasStubExcludes = Ref.create((Object)false);
            List<File> toCompile = GroovyBuilder.collectChangedFiles(context, dirtyFilesHolder, this.myForStubs, false, (Ref<Boolean>)hasStubExcludes);
            if (toCompile.isEmpty()) {
                ModuleLevelBuilder.ExitCode exitCode = this.hasFilesToCompileForNextRound(context) != false ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                return exitCode;
            }
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("forStubs=" + this.myForStubs);
            }
            if ((finalOutputs = GroovyBuilder.getCanonicalModuleOutputs(context, chunk, (Builder)this)) == null) {
                ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.ABORT;
                return exitCode;
            }
            start = System.currentTimeMillis();
            Map<ModuleBuildTarget, String> generationOutputs = this.myForStubs ? GroovyBuilder.getStubGenerationOutputs(chunk, context) : finalOutputs;
            String compilerOutput = generationOutputs.get(chunk.representativeTarget());
            GroovycOutputParser parser = this.runGroovycOrContinuation(context, chunk, settings, finalOutputs, compilerOutput, toCompile, (Boolean)hasStubExcludes.get());
            Map<ModuleBuildTarget, Collection<GroovycOutputParser.OutputItem>> compiled = GroovyBuilder.processCompiledFiles(context, chunk, generationOutputs, compilerOutput, parser.getSuccessfullyCompiled());
            if (GroovyBuilder.checkChunkRebuildNeeded(context, parser)) {
                GroovyBuilder.clearContinuation(context, chunk);
                ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                return exitCode;
            }
            if (this.myForStubs) {
                GroovyBuilder.addStubRootsToJavacSourcePath(context, generationOutputs);
                GroovyBuilder.rememberStubSources(context, compiled);
            }
            for (CompilerMessage message : parser.getCompilerMessages()) {
                context.processMessage((BuildMessage)message);
            }
            if (!this.myForStubs) {
                GroovyBuilder.updateDependencies(context, toCompile, compiled, outputConsumer, (Builder)this);
            }
            ModuleLevelBuilder.ExitCode exitCode = this.hasFilesToCompileForNextRound(context) != false ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : ModuleLevelBuilder.ExitCode.OK;
            return exitCode;
        }
        catch (Exception e) {
            throw new ProjectBuildException((Throwable)e);
        }
        finally {
            if (start > 0L && LOG.isDebugEnabled()) {
                LOG.debug(this.myBuilderName + " took " + (System.currentTimeMillis() - start) + " on " + chunk.getName());
            }
            if (!this.myForStubs) {
                FILES_MARKED_DIRTY_FOR_NEXT_ROUND.set((UserDataHolder)context, null);
            }
        }
    }

    @NotNull
    private GroovycOutputParser runGroovycOrContinuation(CompileContext context, ModuleChunk chunk, JpsGroovySettings settings, Map<ModuleBuildTarget, String> finalOutputs, String compilerOutput, List<File> toCompile, boolean hasStubExcludes) throws Exception {
        GroovycContinuation continuation = GroovyBuilder.takeContinuation(context, chunk);
        if (continuation != null) {
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("using continuation for " + chunk);
            }
            return continuation.continueCompilation();
        }
        Set<String> toCompilePaths = GroovyBuilder.getPathsToCompile(toCompile);
        JpsSdk<JpsDummyElement> jdk = GroovyBuilder.getJdk(chunk);
        String version = jdk == null ? SystemInfo.JAVA_RUNTIME_VERSION : jdk.getVersionString();
        boolean inProcess = "true".equals(System.getProperty("groovyc.in.process", "true"));
        boolean mayDependOnUtilJar = version != null && StringUtil.compareVersionNumbers((String)version, (String)"1.6") >= 0;
        boolean optimizeClassLoading = !inProcess && mayDependOnUtilJar && ourOptimizeThreshold != 0 && toCompilePaths.size() >= ourOptimizeThreshold;
        Map<String, String> class2Src = GroovyBuilder.buildClassToSourceMap(chunk, context, toCompilePaths, finalOutputs);
        String encoding = context.getProjectDescriptor().getEncodingConfiguration().getPreferredModuleChunkEncoding(chunk);
        ArrayList<String> patchers = new ArrayList<String>();
        for (GroovyBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(GroovyBuilderExtension.class)) {
            patchers.addAll(extension.getCompilationUnitPatchers(context, chunk));
        }
        Collection<String> classpath = GroovyBuilder.generateClasspath(context, chunk);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Optimized class loading: " + optimizeClassLoading);
            LOG.debug("Groovyc classpath: " + classpath);
        }
        File tempFile = GroovycOutputParser.fillFileWithGroovycParameters(compilerOutput, toCompilePaths, finalOutputs.values(), class2Src, encoding, patchers, optimizeClassLoading ? StringUtil.join(classpath, (String)File.pathSeparator) : "");
        GroovycFlavor groovyc = inProcess ? new InProcessGroovyc(finalOutputs.values(), hasStubExcludes) : new ForkedGroovyc(optimizeClassLoading, chunk);
        GroovycOutputParser parser = new GroovycOutputParser(chunk, context);
        continuation = groovyc.runGroovyc(classpath, this.myForStubs, settings, tempFile, parser);
        GroovyBuilder.setContinuation(context, chunk, continuation);
        return parser;
    }

    private static void clearContinuation(CompileContext context, ModuleChunk chunk) {
        GroovycContinuation continuation = GroovyBuilder.takeContinuation(context, chunk);
        if (continuation != null) {
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("clearing continuation for " + chunk);
            }
            continuation.buildAborted();
        }
    }

    @Nullable
    private static GroovycContinuation takeContinuation(CompileContext context, ModuleChunk chunk) {
        Map map = (Map)CONTINUATIONS.get((UserDataHolder)context);
        return map == null ? null : (GroovycContinuation)map.remove(chunk);
    }

    private static void setContinuation(CompileContext context, ModuleChunk chunk, @Nullable GroovycContinuation continuation) {
        GroovyBuilder.clearContinuation(context, chunk);
        if (continuation != null) {
            Map map;
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("registering continuation for " + chunk);
            }
            if ((map = (Map)CONTINUATIONS.get((UserDataHolder)context)) == null) {
                map = ContainerUtil.newConcurrentMap();
                CONTINUATIONS.set((UserDataHolder)context, (Object)map);
            }
            map.put(chunk, continuation);
        }
    }

    private Boolean hasFilesToCompileForNextRound(CompileContext context) {
        return !this.myForStubs && (Boolean)FILES_MARKED_DIRTY_FOR_NEXT_ROUND.get((UserDataHolder)context, (Object)Boolean.FALSE) != false;
    }

    private static Set<String> getPathsToCompile(List<File> toCompile) {
        LinkedHashSet<String> toCompilePaths = new LinkedHashSet<String>();
        for (File file : toCompile) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path to compile: " + file.getPath());
            }
            toCompilePaths.add(FileUtil.toSystemIndependentName((String)file.getPath()));
        }
        return toCompilePaths;
    }

    private static boolean checkChunkRebuildNeeded(CompileContext context, GroovycOutputParser parser) {
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context) || !parser.shouldRetry()) {
            return false;
        }
        if (CHUNK_REBUILD_ORDERED.get((UserDataHolder)context) != null) {
            CHUNK_REBUILD_ORDERED.set((UserDataHolder)context, null);
            return false;
        }
        CHUNK_REBUILD_ORDERED.set((UserDataHolder)context, (Object)Boolean.TRUE);
        LOG.info("Order chunk rebuild");
        return true;
    }

    private static void rememberStubSources(CompileContext context, Map<ModuleBuildTarget, Collection<GroovycOutputParser.OutputItem>> compiled) {
        HashMap<String, String> stubToSrc = (HashMap<String, String>)STUB_TO_SRC.get((UserDataHolder)context);
        if (stubToSrc == null) {
            stubToSrc = new HashMap<String, String>();
            STUB_TO_SRC.set((UserDataHolder)context, stubToSrc);
        }
        for (Collection<GroovycOutputParser.OutputItem> items : compiled.values()) {
            for (GroovycOutputParser.OutputItem item : items) {
                stubToSrc.put(FileUtil.toSystemIndependentName((String)item.outputPath), item.sourcePath);
            }
        }
    }

    private static void addStubRootsToJavacSourcePath(CompileContext context, Map<ModuleBuildTarget, String> generationOutputs) {
        BuildRootIndex rootsIndex = context.getProjectDescriptor().getBuildRootIndex();
        for (ModuleBuildTarget target : generationOutputs.keySet()) {
            File root = new File(generationOutputs.get(target));
            rootsIndex.associateTempRoot(context, (BuildTarget)target, (BuildRootDescriptor)new JavaSourceRootDescriptor(root, target, true, true, "", Collections.emptySet()));
        }
    }

    public static Map<ModuleBuildTarget, Collection<GroovycOutputParser.OutputItem>> processCompiledFiles(CompileContext context, ModuleChunk chunk, Map<ModuleBuildTarget, String> generationOutputs, String compilerOutput, List<GroovycOutputParser.OutputItem> successfullyCompiled) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        THashMap compiled = new THashMap();
        for (GroovycOutputParser.OutputItem item : successfullyCompiled) {
            JavaSourceRootDescriptor rd;
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("compiled=" + item);
            }
            if ((rd = pd.getBuildRootIndex().findJavaRootDescriptor(context, new File(item.sourcePath))) != null) {
                String outputPath = GroovyBuilder.ensureCorrectOutput(chunk, item, generationOutputs, compilerOutput, rd.target);
                ArrayList<GroovycOutputParser.OutputItem> items = (ArrayList<GroovycOutputParser.OutputItem>)compiled.get(rd.target);
                if (items == null) {
                    items = new ArrayList<GroovycOutputParser.OutputItem>();
                    compiled.put(rd.target, items);
                }
                items.add(new GroovycOutputParser.OutputItem(outputPath, item.sourcePath));
                continue;
            }
            if (!Utils.IS_TEST_MODE && !LOG.isDebugEnabled()) continue;
            LOG.info("No java source root descriptor for the item found =" + item);
        }
        if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
            LOG.info("Chunk " + chunk + " compilation finished");
        }
        return compiled;
    }

    public void buildStarted(CompileContext context) {
        File stubRoot;
        if (this.myForStubs && (stubRoot = GroovyBuilder.getStubRoot(context)).exists() && !FileUtil.deleteWithRenaming((File)stubRoot)) {
            context.processMessage((BuildMessage)new CompilerMessage(this.myBuilderName, BuildMessage.Kind.ERROR, "External make cannot clean " + stubRoot.getPath()));
        }
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources((CompileContext)context);
        GroovyBuilder.clearContinuation(context, chunk);
        STUB_TO_SRC.set((UserDataHolder)context, null);
    }

    private static Map<ModuleBuildTarget, String> getStubGenerationOutputs(ModuleChunk chunk, CompileContext context) throws IOException {
        HashMap<ModuleBuildTarget, String> generationOutputs = new HashMap<ModuleBuildTarget, String>();
        File commonRoot = GroovyBuilder.getStubRoot(context);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File targetRoot = new File(commonRoot, target.getModule().getName() + File.separator + target.getTargetType().getTypeId());
            if (targetRoot.exists() && !FileUtil.deleteWithRenaming((File)targetRoot)) {
                throw new IOException("External make cannot clean " + targetRoot.getPath());
            }
            if (!targetRoot.mkdirs()) {
                throw new IOException("External make cannot create " + targetRoot.getPath());
            }
            generationOutputs.put(target, targetRoot.getPath());
        }
        return generationOutputs;
    }

    private static File getStubRoot(CompileContext context) {
        return new File(context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot(), "groovyStubs");
    }

    @Nullable
    public static Map<ModuleBuildTarget, String> getCanonicalModuleOutputs(CompileContext context, ModuleChunk chunk, Builder builder) {
        LinkedHashMap<ModuleBuildTarget, String> finalOutputs = new LinkedHashMap<ModuleBuildTarget, String>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File moduleOutputDir = target.getOutputDir();
            if (moduleOutputDir == null) {
                context.processMessage((BuildMessage)new CompilerMessage(builder.getPresentableName(), BuildMessage.Kind.ERROR, "Output directory not specified for module " + target.getModule().getName()));
                return null;
            }
            moduleOutputDir.mkdirs();
            String moduleOutputPath = FileUtil.toCanonicalPath((String)moduleOutputDir.getPath());
            assert (moduleOutputPath != null);
            finalOutputs.put(target, moduleOutputPath.endsWith("/") ? moduleOutputPath : moduleOutputPath + "/");
        }
        return finalOutputs;
    }

    private static String ensureCorrectOutput(ModuleChunk chunk, GroovycOutputParser.OutputItem item, Map<ModuleBuildTarget, String> generationOutputs, String compilerOutput, @NotNull ModuleBuildTarget srcTarget) throws IOException {
        if (chunk.getModules().size() > 1 && !srcTarget.equals((Object)chunk.representativeTarget())) {
            File output = new File(item.outputPath);
            String srcTargetOutput = generationOutputs.get(srcTarget);
            if (srcTargetOutput == null) {
                LOG.info("No output for " + srcTarget + "; outputs=" + generationOutputs + "; targets = " + chunk.getTargets());
                return item.outputPath;
            }
            File correctRoot = new File(srcTargetOutput);
            File correctOutput = new File(correctRoot, FileUtil.getRelativePath((File)new File(compilerOutput), (File)output));
            FileUtil.rename((File)output, (File)correctOutput);
            return correctOutput.getPath();
        }
        return item.outputPath;
    }

    static JpsSdk<JpsDummyElement> getJdk(ModuleChunk chunk) {
        return ((JpsModule)chunk.getModules().iterator().next()).getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
    }

    static List<File> collectChangedFiles(CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, final boolean forStubs, final boolean forEclipse, final Ref<Boolean> hasExcludes) throws IOException {
        final JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
        assert (configuration != null);
        final JpsGroovySettings settings = JpsGroovySettings.getSettings(context.getProjectDescriptor().getProject());
        final ArrayList<File> toCompile = new ArrayList<File>();
        dirtyFilesHolder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>(){

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor sourceRoot) throws IOException {
                String path = file.getPath();
                if ((GroovyBuilder.isGroovyFile(path) || forEclipse && path.endsWith(".java")) && !configuration.isResourceFile(file, sourceRoot.root)) {
                    if (forStubs && settings.isExcludedFromStubGeneration(file)) {
                        hasExcludes.set((Object)true);
                        return true;
                    }
                    toCompile.add(file);
                }
                return true;
            }
        });
        return toCompile;
    }

    public static void updateDependencies(CompileContext context, List<File> toCompile, Map<ModuleBuildTarget, Collection<GroovycOutputParser.OutputItem>> successfullyCompiled, ModuleLevelBuilder.OutputConsumer outputConsumer, Builder builder) throws IOException {
        JavaBuilderUtil.registerFilesToCompile((CompileContext)context, toCompile);
        if (!successfullyCompiled.isEmpty()) {
            Callbacks.Backend callback = JavaBuilderUtil.getDependenciesRegistrar((CompileContext)context);
            for (Map.Entry<ModuleBuildTarget, Collection<GroovycOutputParser.OutputItem>> entry : successfullyCompiled.entrySet()) {
                ModuleBuildTarget target = entry.getKey();
                Collection<GroovycOutputParser.OutputItem> compiled = entry.getValue();
                for (GroovycOutputParser.OutputItem item : compiled) {
                    String sourcePath = FileUtil.toSystemIndependentName((String)item.sourcePath);
                    String outputPath = FileUtil.toSystemIndependentName((String)item.outputPath);
                    File outputFile = new File(outputPath);
                    File srcFile = new File(sourcePath);
                    try {
                        byte[] bytes = FileUtil.loadFileBytes((File)outputFile);
                        if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                            LOG.info("registerCompiledClass " + outputFile + " from " + srcFile);
                        }
                        outputConsumer.registerCompiledClass((BuildTarget)target, new CompiledClass(outputFile, srcFile, GroovyBuilder.readClassName(bytes), new BinaryContent(bytes)));
                        callback.associate(outputPath, sourcePath, (ClassReader)new FailSafeClassReader(bytes));
                    }
                    catch (Throwable e) {
                        String message = "Class dependency information may be incomplete! Error parsing generated class " + item.outputPath;
                        LOG.info(message, e);
                        context.processMessage((BuildMessage)new CompilerMessage(builder.getPresentableName(), BuildMessage.Kind.WARNING, message + "\n" + CompilerMessage.getTextFromThrowable((Throwable)e), sourcePath));
                    }
                    JavaBuilderUtil.registerSuccessfullyCompiled((CompileContext)context, (File)srcFile);
                }
            }
        }
    }

    private static String readClassName(byte[] classBytes) throws IOException {
        final Ref nameRef = Ref.create(null);
        new ClassReader(classBytes).accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                nameRef.set((Object)name.replace('/', '.'));
            }
        }, 7);
        return (String)nameRef.get();
    }

    private static Collection<String> generateClasspath(CompileContext context, ModuleChunk chunk) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        cp.addAll(GroovyBuilder.getGroovyRtRoots());
        for (File file : ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false)) {
            cp.add(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        for (GroovyBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(GroovyBuilderExtension.class)) {
            cp.addAll(extension.getCompilationClassPath(context, chunk));
        }
        return cp;
    }

    static List<String> getGroovyRtRoots() {
        File rt = ClasspathBootstrap.getResourceFile(GroovyBuilder.class);
        File constants = ClasspathBootstrap.getResourceFile(GroovyRtConstants.class);
        return Arrays.asList(new File(rt.getParentFile(), rt.isFile() ? "groovy_rt.jar" : "groovy_rt").getPath(), new File(constants.getParentFile(), constants.isFile() ? "groovy-rt-constants.jar" : "groovy-rt-constants").getPath());
    }

    public static boolean isGroovyFile(String path) {
        return path.endsWith(".groovy");
    }

    public List<String> getCompilableFileExtensions() {
        return Collections.singletonList(GROOVY_EXTENSION);
    }

    private static Map<String, String> buildClassToSourceMap(ModuleChunk chunk, CompileContext context, Set<String> toCompilePaths, Map<ModuleBuildTarget, String> finalOutputs) throws IOException {
        HashMap<String, String> class2Src = new HashMap<String, String>();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(context.getProjectDescriptor().getProject());
        for (ModuleBuildTarget target : chunk.getTargets()) {
            String moduleOutputPath = finalOutputs.get(target);
            SourceToOutputMapping srcToOut = context.getProjectDescriptor().dataManager.getSourceToOutputMap((BuildTarget)target);
            for (String src : srcToOut.getSources()) {
                Collection outs;
                if (toCompilePaths.contains(src) || !GroovyBuilder.isGroovyFile(src) || configuration.getCompilerExcludes().isExcluded(new File(src)) || (outs = srcToOut.getOutputs(src)) == null) continue;
                for (String out : outs) {
                    if (!out.endsWith(".class") || !out.startsWith(moduleOutputPath)) continue;
                    String className = out.substring(moduleOutputPath.length(), out.length() - ".class".length()).replace('/', '.');
                    class2Src.put(className, src);
                }
            }
        }
        return class2Src;
    }

    public String toString() {
        return this.myBuilderName;
    }

    @NotNull
    public String getPresentableName() {
        return this.myBuilderName;
    }

    static {
        JavaBuilder.registerClassPostProcessor((ClassPostProcessor)new RecompileStubSources());
    }

    private static class RecompileStubSources
    implements ClassPostProcessor {
        private RecompileStubSources() {
        }

        public void process(CompileContext context, OutputFileObject out) {
            Map stubToSrc = (Map)STUB_TO_SRC.get((UserDataHolder)context);
            if (stubToSrc == null) {
                return;
            }
            File src = out.getSourceFile();
            if (src == null) {
                return;
            }
            String groovy = (String)stubToSrc.get(FileUtil.toSystemIndependentName((String)src.getPath()));
            if (groovy == null) {
                return;
            }
            try {
                File groovyFile = new File(groovy);
                if (!FSOperations.isMarkedDirty((CompileContext)context, (CompilationRound)CompilationRound.CURRENT, (File)groovyFile)) {
                    FSOperations.markDirty((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (File)groovyFile);
                    FILES_MARKED_DIRTY_FOR_NEXT_ROUND.set((UserDataHolder)context, (Object)Boolean.TRUE);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

