/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

class EcjPsiClassType
extends PsiClassType {
    private final ReferenceBinding mReferenceBinding;
    private final EcjPsiManager mManager;

    EcjPsiClassType(EcjPsiManager manager, ReferenceBinding referenceBinding) {
        super(null);
        this.mManager = manager;
        this.mReferenceBinding = referenceBinding;
    }

    ReferenceBinding getBinding() {
        return this.mReferenceBinding;
    }

    public PsiClass resolve() {
        return this.mManager.findClass((Binding)this.mReferenceBinding);
    }

    public String getClassName() {
        char[][] compoundName = this.mReferenceBinding.compoundName;
        if (compoundName != null) {
            return EcjPsiManager.getTypeName(compoundName[compoundName.length - 1]);
        }
        return EcjPsiManager.getTypeName(this.mReferenceBinding.sourceName);
    }

    public PsiType[] getParameters() {
        if (this.mReferenceBinding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding binding = (ParameterizedTypeBinding)this.mReferenceBinding;
            TypeBinding[] bindings = binding.arguments;
            if (bindings != null && bindings.length > 0) {
                ArrayList types = Lists.newArrayListWithExpectedSize((int)bindings.length);
                for (TypeBinding b : bindings) {
                    PsiType type = this.mManager.findType(b);
                    if (type == null) continue;
                    types.add(type);
                }
                return types.toArray(PsiType.EMPTY_ARRAY);
            }
        }
        return PsiType.EMPTY_ARRAY;
    }

    public PsiClassType.ClassResolveResult resolveGenerics() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClassType rawType() {
        return this;
    }

    public String getPresentableText() {
        return this.getCanonicalText();
    }

    public String getCanonicalText() {
        char[] sourceName;
        if (this.mReferenceBinding.compoundName == null && (sourceName = this.mReferenceBinding.sourceName()) != null) {
            return new String(sourceName);
        }
        return EcjPsiManager.getTypeName(this.mReferenceBinding);
    }

    public String getInternalCanonicalText() {
        return EcjPsiManager.getInternalName(this.mReferenceBinding.compoundName);
    }

    public boolean isValid() {
        return true;
    }

    public boolean equalsToText(String s) {
        return s.equals(this.getCanonicalText());
    }

    public LanguageLevel getLanguageLevel() {
        return this.mManager.getLanguageLevel();
    }
}

