/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.base.Objects;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.meta.PsiMetaData;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

class EcjPsiAnnotation
extends EcjPsiSourceElement
implements PsiAnnotation {
    private final Annotation mAnnotation;
    private String mQualifiedName;
    private PsiAnnotationParameterList mParameterList;
    private PsiJavaCodeReferenceElement mIdentifier;

    EcjPsiAnnotation(EcjPsiManager manager, Annotation ecjAnnotation) {
        super(manager, null);
        this.mAnnotation = ecjAnnotation;
        this.mNativeNode = this.mAnnotation;
        this.setRange(ecjAnnotation.sourceStart, ecjAnnotation.declarationSourceEnd + 1);
    }

    void setNameElement(PsiJavaCodeReferenceElement identifier) {
        this.mIdentifier = identifier;
    }

    void setParameterList(PsiAnnotationParameterList parameterList) {
        this.mParameterList = parameterList;
    }

    public String getQualifiedName() {
        if (this.mQualifiedName == null) {
            this.mQualifiedName = this.mAnnotation.resolvedType instanceof ReferenceBinding ? EcjPsiManager.getTypeName(((ReferenceBinding)this.mAnnotation.resolvedType).compoundName) : EcjPsiManager.getTypeName(this.mAnnotation.type);
        }
        return this.mQualifiedName;
    }

    public PsiAnnotationOwner getOwner() {
        EcjPsiSourceElement parent = this.getParent();
        while (parent != null) {
            if (parent instanceof PsiAnnotationOwner) {
                return (PsiAnnotationOwner)parent;
            }
            parent = this.getParent();
        }
        return null;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiAnnotationParameterList getParameterList() {
        return this.mParameterList;
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.mIdentifier;
    }

    public PsiAnnotationMemberValue findAttributeValue(String s) {
        if (this.mParameterList == null) {
            return null;
        }
        for (PsiNameValuePair pair : this.mParameterList.getAttributes()) {
            if (!Objects.equal((Object)pair.getName(), (Object)s)) continue;
            return pair.getValue();
        }
        return null;
    }

    public PsiAnnotationMemberValue findDeclaredAttributeValue(String s) {
        return this.findAttributeValue(s);
    }

    public PsiMetaData getMetaData() {
        throw new UnimplementedLintPsiApiException();
    }
}

