/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.EcjParser;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintCliXmlParser;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@Beta
public class LintCliClient
extends LintClient {
    protected final List<Warning> mWarnings = new ArrayList<Warning>();
    protected boolean mHasErrors;
    protected int mErrorCount;
    protected int mWarningCount;
    protected IssueRegistry mRegistry;
    protected LintDriver mDriver;
    protected final LintCliFlags mFlags;
    private Configuration mConfiguration;
    private boolean mValidatedIds;
    private final Map<File, String> mFileContents = new HashMap<File, String>(100);
    private Map<Project, LintClient.ClassPathInfo> mProjectInfo;
    private static Set<File> sAlreadyWarned;

    public LintCliClient() {
        super("cli");
        this.mFlags = new LintCliFlags();
        TextReporter reporter = new TextReporter(this, this.mFlags, new PrintWriter(System.out, true), false);
        this.mFlags.getReporters().add(reporter);
    }

    public LintCliClient(LintCliFlags flags, String clientName) {
        super(clientName);
        this.mFlags = flags;
    }

    public int run(IssueRegistry registry, List<File> files) throws IOException {
        assert (!this.mFlags.getReporters().isEmpty());
        this.mRegistry = registry;
        this.mDriver = new LintDriver(registry, (LintClient)this);
        this.mDriver.setAbbreviating(!this.mFlags.isShowEverything());
        this.addProgressPrinter();
        this.mDriver.addLintListener(new LintListener(){

            public void update(LintDriver driver, LintListener.EventType type, Context context) {
                if (type == LintListener.EventType.SCANNING_PROJECT && !LintCliClient.this.mValidatedIds) {
                    LintCliClient.this.validateIssueIds(context != null ? context.getProject() : null);
                }
            }
        });
        this.mDriver.analyze(this.createLintRequest(files));
        Collections.sort(this.mWarnings);
        boolean hasConsoleOutput = false;
        for (Reporter reporter : this.mFlags.getReporters()) {
            reporter.write(this.mErrorCount, this.mWarningCount, this.mWarnings);
            if (!(reporter instanceof TextReporter) || !((TextReporter)reporter).isWriteToConsole()) continue;
            hasConsoleOutput = true;
        }
        if (!this.mFlags.isQuiet() && !hasConsoleOutput) {
            System.out.println(String.format("Lint found %1$d errors and %2$d warnings", this.mErrorCount, this.mWarningCount));
        }
        return this.mFlags.isSetExitCode() ? (this.mHasErrors ? 1 : 0) : 0;
    }

    protected void addProgressPrinter() {
        if (!this.mFlags.isQuiet()) {
            this.mDriver.addLintListener((LintListener)new ProgressPrinter());
        }
    }

    protected LintRequest createLintRequest(List<File> files) {
        return new LintRequest((LintClient)this, files);
    }

    public void log(Severity severity, Throwable exception, String format, Object ... args) {
        System.out.flush();
        if (!this.mFlags.isQuiet()) {
            System.err.println();
        }
        if (format != null) {
            System.err.println(String.format(format, args));
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public XmlParser getXmlParser() {
        return new LintCliXmlParser();
    }

    public Configuration getConfiguration(Project project, LintDriver driver) {
        return new CliConfiguration(this.getConfiguration(), project, this.mFlags.isFatalOnly());
    }

    private String getContents(File file) {
        String s = this.mFileContents.get(file);
        if (s == null) {
            s = this.readFile(file);
            this.mFileContents.put(file, s);
        }
        return s;
    }

    public JavaParser getJavaParser(Project project) {
        return new EcjParser(this, project);
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
        File file;
        assert (context.isEnabled(issue) || issue == IssueRegistry.LINT_ERROR);
        if (severity == Severity.IGNORE) {
            return;
        }
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            this.mHasErrors = true;
            ++this.mErrorCount;
        } else {
            ++this.mWarningCount;
        }
        message = format.convertTo(message, TextFormat.RAW);
        Warning warning = new Warning(issue, message, severity, context.getProject());
        this.mWarnings.add(warning);
        if (location == null) {
            this.log(Severity.ERROR, null, "No location provided for issue " + issue, new Object[0]);
            return;
        }
        warning.location = location;
        warning.file = file = location.getFile();
        warning.path = this.getDisplayPath(context.getProject(), file);
        Position startPosition = location.getStart();
        if (startPosition != null) {
            int line;
            warning.line = line = startPosition.getLine();
            warning.offset = startPosition.getOffset();
            if (line >= 0) {
                if (context.file == location.getFile()) {
                    warning.fileContents = context.getContents();
                }
                if (warning.fileContents == null) {
                    warning.fileContents = this.getContents(location.getFile());
                }
                if (this.mFlags.isShowSourceLines()) {
                    warning.errorLine = LintCliClient.getLine(warning.fileContents, line);
                    if (warning.errorLine != null) {
                        warning.errorLine = warning.errorLine.replace('\t', ' ');
                        int column = startPosition.getColumn();
                        if (column < 0) {
                            column = 0;
                            int i = 0;
                            while (i < warning.errorLine.length() && Character.isWhitespace(warning.errorLine.charAt(i))) {
                                ++i;
                                ++column;
                            }
                        }
                        StringBuilder sb = new StringBuilder(100);
                        sb.append(warning.errorLine);
                        sb.append('\n');
                        for (int i = 0; i < column; ++i) {
                            sb.append(' ');
                        }
                        boolean displayCaret = true;
                        Position endPosition = location.getEnd();
                        if (endPosition != null) {
                            int endLine = endPosition.getLine();
                            int endColumn = endPosition.getColumn();
                            if (endLine == line && endColumn > column) {
                                for (int i = column; i < endColumn; ++i) {
                                    sb.append('~');
                                }
                                displayCaret = false;
                            }
                        }
                        if (displayCaret) {
                            sb.append('^');
                        }
                        sb.append('\n');
                        warning.errorLine = sb.toString();
                    }
                }
            }
        }
    }

    static String getLine(String contents, int line) {
        int index = LintCliClient.getLineOffset(contents, line);
        if (index != -1) {
            return LintCliClient.getLineOfOffset(contents, index);
        }
        return null;
    }

    static String getLineOfOffset(String contents, int offset) {
        int end = contents.indexOf(10, offset);
        if (end == -1) {
            end = contents.indexOf(13, offset);
        }
        return contents.substring(offset, end != -1 ? end : contents.length());
    }

    static int getLineOffset(String contents, int line) {
        int index = 0;
        for (int i = 0; i < line; ++i) {
            if ((index = contents.indexOf(10, index)) == -1) {
                return -1;
            }
            ++index;
        }
        return index;
    }

    public String readFile(File file) {
        try {
            return LintUtils.getEncodedString((LintClient)this, (File)file);
        }
        catch (IOException e) {
            return "";
        }
    }

    boolean isCheckingSpecificIssues() {
        return this.mFlags.getExactCheckedIds() != null;
    }

    protected LintClient.ClassPathInfo getClassPath(Project project) {
        LintClient.ClassPathInfo info;
        LintClient.ClassPathInfo classPath = super.getClassPath(project);
        List sources = this.mFlags.getSourcesOverride();
        List classes = this.mFlags.getClassesOverride();
        List libraries = this.mFlags.getLibrariesOverride();
        if (classes == null && sources == null && libraries == null) {
            return classPath;
        }
        if (this.mProjectInfo == null) {
            this.mProjectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.mProjectInfo.get(project);
        }
        if (info == null) {
            if (sources == null) {
                sources = classPath.getSourceFolders();
            }
            if (classes == null) {
                classes = classPath.getClassFolders();
            }
            if (libraries == null) {
                libraries = classPath.getLibraries(true);
            }
            info = new LintClient.ClassPathInfo(sources, classes, libraries, classPath.getLibraries(false), classPath.getTestSourceFolders());
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    public List<File> getResourceFolders(Project project) {
        List<File> resources = this.mFlags.getResourcesOverride();
        if (resources == null) {
            return super.getResourceFolders(project);
        }
        return resources;
    }

    private void validateIssueIds(Project project) {
        if (this.mDriver != null) {
            IssueRegistry registry = this.mDriver.getRegistry();
            if (!registry.isIssueId(HardcodedValuesDetector.ISSUE.getId())) {
                return;
            }
            this.mValidatedIds = true;
            this.validateIssueIds(project, registry, this.mFlags.getExactCheckedIds());
            this.validateIssueIds(project, registry, this.mFlags.getEnabledIds());
            this.validateIssueIds(project, registry, this.mFlags.getSuppressedIds());
            this.validateIssueIds(project, registry, this.mFlags.getSeverityOverrides().keySet());
        }
    }

    private void validateIssueIds(Project project, IssueRegistry registry, Collection<String> ids) {
        if (ids != null) {
            for (String id : ids) {
                if (registry.getIssue(id) != null) continue;
                this.reportNonExistingIssueId(project, id);
            }
        }
    }

    protected void reportNonExistingIssueId(Project project, String id) {
        String message = String.format("Unknown issue id \"%1$s\"", id);
        if (this.mDriver != null && project != null) {
            Location location = Location.create((File)project.getDir());
            if (!this.isSuppressed(IssueRegistry.LINT_ERROR)) {
                this.report(new Context(this.mDriver, project, project, project.getDir()), IssueRegistry.LINT_ERROR, project.getConfiguration(this.mDriver).getSeverity(IssueRegistry.LINT_ERROR), location, message, TextFormat.RAW);
            }
        } else {
            this.log(Severity.ERROR, null, "Lint: %1$s", message);
        }
    }

    static String getCleanPath(File file) {
        String path = file.getPath();
        StringBuilder sb = new StringBuilder(path.length());
        if (path.startsWith(File.separator)) {
            sb.append(File.separator);
        }
        block0: for (String element : Splitter.on((char)File.separatorChar).omitEmptyStrings().split((CharSequence)path)) {
            if (element.equals(".")) continue;
            if (element.equals("..") && sb.length() > 0) {
                for (int i = sb.length() - 1; i >= 0; --i) {
                    char c = sb.charAt(i);
                    if (c != File.separatorChar) continue;
                    sb.setLength(i == 0 ? 1 : i);
                    continue block0;
                }
                sb.setLength(0);
                continue;
            }
            if (sb.length() > 1) {
                sb.append(File.separatorChar);
            } else if (sb.length() > 0 && sb.charAt(0) != File.separatorChar) {
                sb.append(File.separatorChar);
            }
            sb.append(element);
        }
        if (path.endsWith(File.separator) && sb.length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        return sb.toString();
    }

    String getDisplayPath(Project project, File file) {
        String path = file.getPath();
        if (!this.mFlags.isFullPath() && path.startsWith(project.getReferenceDir().getPath())) {
            int chop = project.getReferenceDir().getPath().length();
            if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                ++chop;
            }
            if ((path = path.substring(chop)).isEmpty()) {
                path = file.getName();
            }
        } else if (this.mFlags.isFullPath()) {
            path = LintCliClient.getCleanPath(file.getAbsoluteFile());
        }
        return path;
    }

    boolean isAllEnabled() {
        return this.mFlags.isCheckAllWarnings();
    }

    IssueRegistry getRegistry() {
        return this.mRegistry;
    }

    LintDriver getDriver() {
        return this.mDriver;
    }

    Configuration getConfiguration() {
        File configFile;
        if (this.mConfiguration == null && (configFile = this.mFlags.getDefaultConfiguration()) != null) {
            if (!configFile.exists()) {
                if (sAlreadyWarned == null || !sAlreadyWarned.contains(configFile)) {
                    this.log(Severity.ERROR, null, "Warning: Configuration file %1$s does not exist", configFile);
                }
                if (sAlreadyWarned == null) {
                    sAlreadyWarned = Sets.newHashSet();
                }
                sAlreadyWarned.add(configFile);
            }
            this.mConfiguration = this.createConfigurationFromFile(configFile);
        }
        return this.mConfiguration;
    }

    boolean isSuppressed(Issue issue) {
        return this.mFlags.getSuppressedIds().contains(issue.getId());
    }

    public Configuration createConfigurationFromFile(File file) {
        return new CliConfiguration(file, this.mFlags.isFatalOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRevision() {
        File file = this.findResource("tools" + File.separator + "source.properties");
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(input);
                String revision = properties.getProperty("Pkg.Revision");
                if (revision != null && !revision.isEmpty()) {
                    String string = revision;
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    Closeables.close((Closeable)input, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public LintCliFlags getFlags() {
        return this.mFlags;
    }

    public boolean haveErrors() {
        return this.mErrorCount > 0;
    }

    public void reset() {
        this.mWarnings.clear();
        this.mErrorCount = 0;
        this.mWarningCount = 0;
        this.mProjectDirs = Sets.newHashSet();
        this.mDirToProject = null;
    }

    private static class ProgressPrinter
    implements LintListener {
        private ProgressPrinter() {
        }

        public void update(LintDriver lint, LintListener.EventType type, Context context) {
            switch (type) {
                case SCANNING_PROJECT: {
                    String name;
                    String string = name = context != null ? context.getProject().getName() : "?";
                    if (lint.getPhase() > 1) {
                        System.out.print(String.format("\nScanning %1$s (Phase %2$d): ", name, lint.getPhase()));
                        break;
                    }
                    System.out.print(String.format("\nScanning %1$s: ", name));
                    break;
                }
                case SCANNING_LIBRARY_PROJECT: {
                    String name = context != null ? context.getProject().getName() : "?";
                    System.out.print(String.format("\n         - %1$s: ", name));
                    break;
                }
                case SCANNING_FILE: {
                    System.out.print('.');
                    break;
                }
                case NEW_PHASE: {
                    break;
                }
                case CANCELED: 
                case COMPLETED: {
                    System.out.println();
                    break;
                }
            }
        }
    }

    class CliConfiguration
    extends DefaultConfiguration {
        private boolean mFatalOnly;

        CliConfiguration(Configuration parent, Project project, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, project, parent);
            this.mFatalOnly = fatalOnly;
        }

        CliConfiguration(File lintFile, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, null, null, lintFile);
            this.mFatalOnly = fatalOnly;
        }

        public Severity getSeverity(Issue issue) {
            Severity severity = this.computeSeverity(issue);
            if (this.mFatalOnly && severity != Severity.FATAL) {
                return Severity.IGNORE;
            }
            if (LintCliClient.this.mFlags.isWarningsAsErrors() && severity == Severity.WARNING) {
                severity = Severity.ERROR;
            }
            if (LintCliClient.this.mFlags.isIgnoreWarnings() && severity == Severity.WARNING) {
                severity = Severity.IGNORE;
            }
            return severity;
        }

        protected Severity getDefaultSeverity(Issue issue) {
            if (LintCliClient.this.mFlags.isCheckAllWarnings()) {
                return issue.getDefaultSeverity();
            }
            return super.getDefaultSeverity(issue);
        }

        private Severity computeSeverity(Issue issue) {
            Severity severity = super.getSeverity(issue);
            String id = issue.getId();
            Set<String> suppress = LintCliClient.this.mFlags.getSuppressedIds();
            if (suppress.contains(id)) {
                return Severity.IGNORE;
            }
            Severity manual = LintCliClient.this.mFlags.getSeverityOverrides().get(id);
            if (manual != null) {
                return manual;
            }
            Set<String> enabled = LintCliClient.this.mFlags.getEnabledIds();
            Set<String> check = LintCliClient.this.mFlags.getExactCheckedIds();
            if (enabled.contains(id) || check != null && check.contains(id)) {
                if (severity == Severity.IGNORE && (severity = issue.getDefaultSeverity()) == Severity.IGNORE) {
                    severity = Severity.WARNING;
                }
                return severity;
            }
            if (check != null && issue != IssueRegistry.LINT_ERROR && issue != IssueRegistry.PARSER_ERROR) {
                return Severity.IGNORE;
            }
            return severity;
        }
    }
}

