/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.Convertor;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.ui.GithubBasicLoginDialog;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

public class GithubUtil {
    public static final Logger LOG = Logger.getInstance((String)"github");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        GithubAuthData auth = authHolder.getAuthData();
        try {
            GithubConnection connection = new GithubConnection(auth, true);
            ScheduledFuture<?> future = null;
            try {
                future = GithubUtil.addCancellationListener(indicator, connection);
                Object object = task.convert((Object)connection);
                return (T)object;
            }
            finally {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
            }
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            return GithubUtil.runTask(project, authHolder, indicator, task);
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, auth);
            return GithubUtil.runTask(project, authHolder, indicator, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runTaskWithBasicAuthForHost(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull String host, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        GithubAuthData auth = authHolder.getAuthData();
        try {
            if (auth.getAuthType() != GithubAuthData.AuthType.BASIC) {
                throw new GithubAuthenticationException("Expected basic authentication");
            }
            GithubConnection connection = new GithubConnection(auth, true);
            ScheduledFuture<?> future = null;
            try {
                future = GithubUtil.addCancellationListener(indicator, connection);
                Object object = task.convert((Object)connection);
                return (T)object;
            }
            finally {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
            }
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            return GithubUtil.runTaskWithBasicAuthForHost(project, authHolder, indicator, host, task);
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidBasicAuthDataForHost(project, authHolder, indicator, auth, host);
            return GithubUtil.runTaskWithBasicAuthForHost(project, authHolder, indicator, host, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static GithubUserDetailed testConnection(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        GithubUserDetailed githubUserDetailed;
        GithubAuthData auth = authHolder.getAuthData();
        GithubConnection connection = new GithubConnection(auth, true);
        ScheduledFuture<?> future = null;
        try {
            future = GithubUtil.addCancellationListener(indicator, connection);
            githubUserDetailed = GithubApiUtil.getCurrentUserDetailed(connection);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
                throw throwable;
            }
            catch (GithubTwoFactorAuthenticationException e) {
                GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
                return GithubUtil.testConnection(project, authHolder, indicator);
            }
        }
        connection.close();
        if (future != null) {
            future.cancel(true);
        }
        return githubUserDetailed;
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull Runnable run) {
        return JobScheduler.getScheduler().scheduleWithFixedDelay(run, 1000L, 300L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(final @NotNull ProgressIndicator indicator, final @NotNull GithubConnection connection) {
        return GithubUtil.addCancellationListener(new Runnable(){

            @Override
            public void run() {
                if (indicator.isCanceled()) {
                    connection.abort();
                }
            }
        });
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(final @NotNull ProgressIndicator indicator, final @NotNull Thread thread) {
        return GithubUtil.addCancellationListener(new Runnable(){

            @Override
            public void run() {
                if (indicator.isCanceled()) {
                    thread.interrupt();
                }
            }
        });
    }

    public static void getValidAuthData(final @NotNull Project project, @NotNull GithubAuthDataHolder authHolder, final @NotNull ProgressIndicator indicator, final @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        authHolder.runTransaction(oldAuth, new ThrowableComputable<GithubAuthData, GithubOperationCanceledException>(){

            @NotNull
            public GithubAuthData compute() throws GithubOperationCanceledException {
                final GithubAuthData[] authData = new GithubAuthData[1];
                final boolean[] ok = new boolean[1];
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GithubLoginDialog dialog = new GithubLoginDialog(project, oldAuth);
                        DialogManager.show((DialogWrapper)dialog);
                        ok[0] = dialog.isOK();
                        if (ok[0]) {
                            authData[0] = dialog.getAuthData();
                            GithubSettings.getInstance().setAuthData(authData[0], dialog.isSavePasswordSelected());
                        }
                    }
                }, indicator.getModalityState());
                if (!ok[0]) {
                    throw new GithubOperationCanceledException("Can't get valid credentials");
                }
                return authData[0];
            }
        });
    }

    public static void getValidBasicAuthDataForHost(final @NotNull Project project, @NotNull GithubAuthDataHolder authHolder, final @NotNull ProgressIndicator indicator, final @NotNull GithubAuthData oldAuth, final @NotNull String host) throws GithubOperationCanceledException {
        authHolder.runTransaction(oldAuth, new ThrowableComputable<GithubAuthData, GithubOperationCanceledException>(){

            @NotNull
            public GithubAuthData compute() throws GithubOperationCanceledException {
                final GithubAuthData[] authData = new GithubAuthData[1];
                final boolean[] ok = new boolean[1];
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GithubBasicLoginDialog dialog = new GithubBasicLoginDialog(project, oldAuth, host);
                        DialogManager.show((DialogWrapper)dialog);
                        ok[0] = dialog.isOK();
                        if (ok[0]) {
                            authData[0] = dialog.getAuthData();
                            GithubSettings settings = GithubSettings.getInstance();
                            if (settings.getAuthType() != GithubAuthData.AuthType.TOKEN) {
                                GithubSettings.getInstance().setAuthData(authData[0], dialog.isSavePasswordSelected());
                            }
                        }
                    }
                }, indicator.getModalityState());
                if (!ok[0]) {
                    throw new GithubOperationCanceledException("Can't get valid credentials");
                }
                return authData[0];
            }
        });
    }

    private static void getTwoFactorAuthData(final @NotNull Project project, final @NotNull GithubAuthDataHolder authHolder, final @NotNull ProgressIndicator indicator, final @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        authHolder.runTransaction(oldAuth, new ThrowableComputable<GithubAuthData, GithubOperationCanceledException>(){

            @NotNull
            public GithubAuthData compute() throws GithubOperationCanceledException {
                if (authHolder.getAuthData().getAuthType() != GithubAuthData.AuthType.BASIC) {
                    throw new GithubOperationCanceledException("Two factor authentication can be used only with Login/Password");
                }
                GithubApiUtil.askForTwoFactorCodeSMS(new GithubConnection(oldAuth, false));
                final Ref codeRef = new Ref();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        codeRef.set((Object)Messages.showInputDialog((Project)project, (String)"Authentication Code", (String)"Github Two-Factor Authentication", null));
                    }
                }, indicator.getModalityState());
                if (codeRef.isNull()) {
                    throw new GithubOperationCanceledException("Can't get two factor authentication code");
                }
                GithubSettings settings = GithubSettings.getInstance();
                if (settings.getAuthType() == GithubAuthData.AuthType.BASIC && StringUtil.equalsIgnoreCase((CharSequence)settings.getLogin(), (CharSequence)oldAuth.getBasicAuth().getLogin())) {
                    settings.setValidGitAuth(false);
                }
                return oldAuth.copyWithTwoFactorCode((String)codeRef.get());
            }
        });
    }

    @NotNull
    public static GithubAuthDataHolder getValidAuthDataHolderFromConfig(@NotNull Project project, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthData auth = GithubAuthData.createFromSettings();
        GithubAuthDataHolder authHolder = new GithubAuthDataHolder(auth);
        try {
            GithubUtil.checkAuthData(project, authHolder, indicator);
            return authHolder;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, auth);
            return authHolder;
        }
    }

    @NotNull
    public static GithubUserDetailed checkAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthData auth = authHolder.getAuthData();
        if (StringUtil.isEmptyOrSpaces((String)auth.getHost())) {
            throw new GithubAuthenticationException("Target host not defined");
        }
        try {
            new URI(auth.getHost());
        }
        catch (URISyntaxException e) {
            throw new GithubAuthenticationException("Invalid host URL");
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
                assert (basicAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)basicAuth.getLogin()) && !StringUtil.isEmptyOrSpaces((String)basicAuth.getPassword())) break;
                throw new GithubAuthenticationException("Empty login or password");
            }
            case TOKEN: {
                GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
                assert (tokenAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)tokenAuth.getToken())) break;
                throw new GithubAuthenticationException("Empty token");
            }
            case ANONYMOUS: {
                throw new GithubAuthenticationException("Anonymous connection not allowed");
            }
        }
        return GithubUtil.testConnection(project, authHolder, indicator);
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, final @NotNull ThrowableConvertor<ProgressIndicator, T, IOException> task) throws IOException {
        final Ref dataRef = new Ref();
        final Ref exceptionRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, caption, true){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    dataRef.set(task.convert((Object)indicator));
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }
        });
        if (!exceptionRef.isNull()) {
            Throwable e = (Throwable)exceptionRef.get();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return (T)dataRef.get();
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, @NotNull Convertor<ProgressIndicator, T> task) {
        return GithubUtil.computeValueInModal(project, caption, true, task);
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Convertor<ProgressIndicator, T> task) {
        final Ref dataRef = new Ref();
        final Ref exceptionRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, caption, canBeCancelled){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    dataRef.set(task.convert((Object)indicator));
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }
        });
        if (!exceptionRef.isNull()) {
            Throwable e = (Throwable)exceptionRef.get();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return (T)dataRef.get();
    }

    public static void computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Consumer<ProgressIndicator> task) {
        final Ref exceptionRef = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, caption, canBeCancelled){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    task.consume((Object)indicator);
                }
                catch (Throwable e) {
                    exceptionRef.set((Object)e);
                }
            }
        });
        if (!exceptionRef.isNull()) {
            Throwable e = (Throwable)exceptionRef.get();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task) throws IOException {
        ScheduledFuture<?> future = null;
        try {
            Thread thread = Thread.currentThread();
            future = GithubUtil.addCancellationListener(indicator, thread);
            Object object = task.compute();
            return (T)object;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @Nullable
    public static String findGithubRemoteUrl(@NotNull GitRepository repository) {
        Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(repository);
        if (remote == null) {
            return null;
        }
        return (String)remote.getSecond();
    }

    @Nullable
    public static Pair<GitRemote, String> findGithubRemote(@NotNull GitRepository repository) {
        Pair githubRemote = null;
        block0: for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                String remoteName = gitRemote.getName();
                if ("github".equals(remoteName) || "origin".equals(remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @Nullable
    public static String findUpstreamRemote(@NotNull GitRepository repository) {
        for (GitRemote gitRemote : repository.getRemotes()) {
            String remoteName = gitRemote.getName();
            if (!"upstream".equals(remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                return remoteUrl;
            }
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    public static boolean testGitExecutable(Project project) {
        GitVersion version;
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        String executable = settings.getPathToGit();
        try {
            version = GitVersion.identifyVersion((String)executable);
        }
        catch (Exception e) {
            GithubNotifications.showErrorDialog(project, GitBundle.getString((String)"find.git.error.title"), e);
            return false;
        }
        if (!version.isSupported()) {
            GithubNotifications.showWarningDialog(project, GitBundle.message((String)"find.git.unsupported.message", (Object[])new Object[]{version.toString(), GitVersion.MIN}), GitBundle.getString((String)"find.git.success.title"));
            return false;
        }
        return true;
    }

    public static boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    public static void setVisibleEnabled(AnActionEvent e, boolean visible, boolean enabled) {
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public static String getErrorTextFromException(@NotNull Exception e) {
        if (e instanceof UnknownHostException) {
            return "Unknown host: " + e.getMessage();
        }
        return e.getMessage();
    }

    @Nullable
    public static GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        GitRepository repository;
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        List repositories = manager.getRepositories();
        if (repositories.size() == 0) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFile(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFile(project.getBaseDir());
    }

    public static boolean addGithubRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote, @NotNull String url) {
        GitSimpleHandler handler = new GitSimpleHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            handler.run();
            if (handler.getExitCode() != 0) {
                GithubNotifications.showError(project, "Can't add remote", "Failed to add GitHub remote: '" + url + "'. " + handler.getStderr());
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException e) {
            GithubNotifications.showError(project, "Can't add remote", (Exception)((Object)e));
            return false;
        }
    }
}

