/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubRepo {
    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    private final boolean myIsPrivate;
    private final boolean myIsFork;
    @NotNull
    private final String myHtmlUrl;
    @NotNull
    private final String myCloneUrl;
    @Nullable
    private final String myDefaultBranch;
    @NotNull
    private final GithubUser myOwner;

    public GithubRepo(@NotNull String name, @Nullable String description, boolean isPrivate, boolean isFork, @NotNull String htmlUrl, @NotNull String cloneUrl, @Nullable String defaultBranch, @NotNull GithubUser owner) {
        this.myName = name;
        this.myDescription = StringUtil.notNullize((String)description);
        this.myIsPrivate = isPrivate;
        this.myIsFork = isFork;
        this.myHtmlUrl = htmlUrl;
        this.myCloneUrl = cloneUrl;
        this.myDefaultBranch = defaultBranch;
        this.myOwner = owner;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getFullName() {
        return this.getUserName() + "/" + this.getName();
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public boolean isPrivate() {
        return this.myIsPrivate;
    }

    public boolean isFork() {
        return this.myIsFork;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.myHtmlUrl;
    }

    @NotNull
    public String getCloneUrl() {
        return this.myCloneUrl;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.myDefaultBranch;
    }

    @NotNull
    public GithubUser getOwner() {
        return this.myOwner;
    }

    @NotNull
    public String getUserName() {
        return this.getOwner().getLogin();
    }

    @NotNull
    public GithubFullPath getFullPath() {
        return new GithubFullPath(this.getUserName(), this.getName());
    }
}

