/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.annotations.SerializedName;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubGist;

class GithubGistRequest {
    @NotNull
    private final String description;
    @NotNull
    private final Map<String, GistFile> files;
    @SerializedName(value="public")
    private final boolean isPublic;

    public GithubGistRequest(@NotNull List<GithubGist.FileContent> files, @NotNull String description, boolean isPublic) {
        this.description = description;
        this.isPublic = isPublic;
        this.files = new HashMap();
        for (GithubGist.FileContent file : files) {
            this.files.put(file.getFileName(), new GistFile(file.getContent()));
        }
    }

    public static class GistFile {
        @NotNull
        private final String content;

        public GistFile(@NotNull String content) {
            this.content = content;
        }
    }
}

