/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubCommitSha;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubCommit
extends GithubCommitSha {
    @Nullable
    private final GithubUser myAuthor;
    @Nullable
    private final GithubUser myCommitter;
    @NotNull
    private final List<GithubCommitSha> myParents;
    @NotNull
    private final GitCommit myCommit;

    public GithubCommit(@NotNull String url, @NotNull String sha, @Nullable GithubUser author, @Nullable GithubUser committer, @NotNull List<GithubCommitSha> parents, @NotNull GitCommit commit) {
        super(url, sha);
        this.myAuthor = author;
        this.myCommitter = committer;
        this.myParents = parents;
        this.myCommit = commit;
    }

    @Nullable
    public GithubUser getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public GithubUser getCommitter() {
        return this.myCommitter;
    }

    @NotNull
    public List<GithubCommitSha> getParents() {
        return this.myParents;
    }

    @NotNull
    public GitCommit getCommit() {
        return this.myCommit;
    }

    public static class GitUser {
        @NotNull
        private final String myName;
        @NotNull
        private final String myEmail;
        @NotNull
        private final Date myDate;

        public GitUser(@NotNull String name, @NotNull String email, @NotNull Date date) {
            this.myName = name;
            this.myEmail = email;
            this.myDate = date;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getEmail() {
            return this.myEmail;
        }

        @NotNull
        public Date getDate() {
            return this.myDate;
        }
    }

    public static class GitCommit {
        @NotNull
        private final String myMessage;
        @NotNull
        private final GitUser myAuthor;
        @NotNull
        private final GitUser myCommitter;

        public GitCommit(@NotNull String message, @NotNull GitUser author, @NotNull GitUser committer) {
            this.myMessage = message;
            this.myAuthor = author;
            this.myCommitter = committer;
        }

        @NotNull
        public String getMessage() {
            return this.myMessage;
        }

        @NotNull
        public GitUser getAuthor() {
            return this.myAuthor;
        }

        @NotNull
        public GitUser getCommitter() {
            return this.myCommitter;
        }
    }
}

