/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import icons.GithubIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubOpenInBrowserAction
extends DumbAwareAction {
    public static final String CANNOT_OPEN_IN_BROWSER = "Cannot open in browser";

    protected GithubOpenInBrowserAction() {
        super("Open on GitHub", "Open corresponding link in browser", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault() || virtualFile == null) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        GitRepository gitRepository = (GitRepository)manager.getRepositoryForFile(virtualFile);
        if (gitRepository == null) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        if (!GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isUnversioned(virtualFile)) {
            GithubUtil.setVisibleEnabled(e, true, false);
            return;
        }
        Change change = changeListManager.getChange(virtualFile);
        if (change != null && change.getType() == Change.Type.NEW) {
            GithubUtil.setVisibleEnabled(e, true, false);
            return;
        }
        GithubUtil.setVisibleEnabled(e, true, true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (virtualFile == null || project == null || project.isDisposed()) {
            return;
        }
        String urlToOpen = GithubOpenInBrowserAction.getGithubUrl(project, virtualFile, editor);
        if (urlToOpen != null) {
            BrowserUtil.browse((String)urlToOpen);
        }
    }

    @Nullable
    private static String getGithubUrl(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable Editor editor) {
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        GitRepository repository = (GitRepository)manager.getRepositoryForFile(virtualFile);
        if (repository == null) {
            StringBuilder details = new StringBuilder("file: " + virtualFile.getPresentableUrl() + "; Git repositories: ");
            for (GitRepository repo : manager.getRepositories()) {
                details.append(repo.getPresentableUrl()).append("; ");
            }
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't find git repository", details.toString());
            return null;
        }
        String githubRemoteUrl = GithubUtil.findGithubRemoteUrl(repository);
        if (githubRemoteUrl == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't find github remote");
            return null;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repository.getRoot());
        if (relativePath == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "File is not under repository root", "Root: " + repository.getRoot().getPresentableUrl() + ", file: " + virtualFile.getPresentableUrl());
            return null;
        }
        String hash = GithubOpenInBrowserAction.getCurrentFileRevisionHash(project, virtualFile);
        if (hash != null) {
            return GithubOpenInBrowserAction.makeUrlToOpen(editor, relativePath, hash, githubRemoteUrl);
        }
        GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't get last revision.");
        return null;
    }

    @Nullable
    private static String makeUrlToOpen(@Nullable Editor editor, @NotNull String relativePath, @NotNull String branch, @NotNull String githubRemoteUrl) {
        StringBuilder builder = new StringBuilder();
        String githubRepoUrl = GithubUrlUtil.makeGithubRepoUrlFromRemoteUrl(githubRemoteUrl);
        if (githubRepoUrl == null) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
            builder.append(githubRepoUrl).append("/tree/").append(branch);
        } else {
            builder.append(githubRepoUrl).append("/blob/").append(branch).append('/').append(relativePath);
        }
        if (editor != null && editor.getDocument().getLineCount() >= 1) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int begin = editor.getDocument().getLineNumber(selectionModel.getSelectionStart()) + 1;
            int selectionEnd = selectionModel.getSelectionEnd();
            int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
            if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                --end;
            }
            builder.append("#L").append(begin).append("-L").append(end);
        }
        return builder.toString();
    }

    @Nullable
    private static String getCurrentFileRevisionHash(final @NotNull Project project, final @NotNull VirtualFile file) {
        final Ref ref = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Getting last revision", true){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file), (String)"HEAD")));
                }
                catch (VcsException e) {
                    GithubUtil.LOG.warn((Throwable)e);
                }
            }

            public void onCancel() {
                throw new ProcessCanceledException();
            }
        });
        if (ref.isNull()) {
            return null;
        }
        return ((GitRevisionNumber)ref.get()).getRev();
    }
}

