/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

class DonePromise<T>
extends Promise<T>
implements Getter<T> {
    private final T result;

    public DonePromise(T result) {
        this.result = result;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done) {
        if (!AsyncPromise.isObsolete(done)) {
            done.consume(this.result);
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        fulfilled.setResult(this.result);
        return this;
    }

    @Override
    public Promise<T> processed(@NotNull Consumer<? super T> processed) {
        this.done(processed);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected) {
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done) {
        if (done instanceof Obsolescent && ((Obsolescent)done).isObsolete()) {
            return Promise.reject("obsolete");
        }
        return Promise.resolve(done.fun(this.result));
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull AsyncFunction<? super T, SUB_RESULT> done) {
        return done.fun(this.result);
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return Promise.State.FULFILLED;
    }

    public T get() {
        return this.result;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        child.setResult(this.result);
    }
}

