/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        public void consume(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        return this.get(true);
    }

    public final T getResult() {
        return (T)((Getter)this.get(true)).get();
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<T> asyncResult) {
        try {
            asyncResult.setError("rejected");
        }
        finally {
            T result = asyncResult.get();
            if (result != null) {
                this.disposeResult(result);
            }
        }
    }

    protected void disposeResult(@NotNull T result) {
        if (result instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result), (boolean)false);
        }
    }

    public final boolean has() {
        Promise<T> result = this.ref.get();
        return result != null && result.getState() == Promise.State.FULFILLED && ((Getter)result).get() != null;
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        Promise<T> promise = this.ref.get();
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.ref.compareAndSet(null, promise)) {
                return this.ref.get();
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                return promise;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(((Getter)promise).get())) {
                    return promise;
                }
                if (!this.ref.compareAndSet(promise, promise = new AsyncPromise())) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet(null, promise)) {
                            return this.getPromise((AsyncPromise)promise);
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise((AsyncPromise)promise);
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise) {
        Promise<T> effectivePromise;
        try {
            effectivePromise = this.load(promise);
            if (effectivePromise != promise) {
                this.ref.compareAndSet(promise, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet(promise, null);
            this.rejectAndDispose(promise);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.done(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.rejected(new Consumer<Throwable>(){

                public void consume(Throwable throwable) {
                    AsyncValueLoader.this.ref.compareAndSet(effectivePromise, null);
                }
            });
        }
        if (effectivePromise != promise) {
            effectivePromise.notify(promise);
        }
        return effectivePromise;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    protected boolean isUpToDate(@Nullable T result) {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result) {
        Promise<T> oldValue = this.ref.getAndSet(Promise.resolve(result));
        if (oldValue != null && oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }
}

