/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.RejectedPromise;

public class AsyncPromise<T>
extends Promise<T>
implements Getter<T> {
    private static final Logger LOG = Logger.getInstance(AsyncPromise.class);
    public static final RuntimeException OBSOLETE_ERROR = Promise.createError("Obsolete");
    private volatile Consumer<? super T> done;
    private volatile Consumer<? super Throwable> rejected;
    protected volatile Promise.State state = Promise.State.PENDING;
    private volatile Object result;

    @Override
    @NotNull
    public Promise.State getState() {
        return this.state;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done) {
        if (AsyncPromise.isObsolete(done)) {
            return this;
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                done.consume(this.result);
                return this;
            }
            case REJECTED: {
                return this;
            }
        }
        this.done = AsyncPromise.setHandler(this.done, done);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected) {
        if (AsyncPromise.isObsolete(rejected)) {
            return this;
        }
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                return this;
            }
            case REJECTED: {
                rejected.consume((Object)((Throwable)this.result));
                return this;
            }
        }
        this.rejected = AsyncPromise.setHandler(this.rejected, rejected);
        return this;
    }

    public T get() {
        return (T)(this.state == Promise.State.FULFILLED ? this.result : null);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(final @NotNull Function<? super T, ? extends SUB_RESULT> fulfilled) {
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                return new DonePromise<Object>(fulfilled.fun(this.result));
            }
            case REJECTED: {
                return new RejectedPromise((Throwable)this.result);
            }
        }
        final AsyncPromise<T> promise = new AsyncPromise<T>();
        this.addHandlers(new Consumer<T>(){

            public void consume(T result) {
                try {
                    if (fulfilled instanceof Obsolescent && ((Obsolescent)fulfilled).isObsolete()) {
                        promise.setError(OBSOLETE_ERROR);
                    } else {
                        promise.setResult(fulfilled.fun(result));
                    }
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            }
        }, new Consumer<Throwable>(){

            public void consume(Throwable error) {
                promise.setError(error);
            }
        });
        return promise;
    }

    @Override
    public void notify(final @NotNull AsyncPromise<? super T> child) {
        LOG.assertTrue(child != this);
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                child.setResult(this.result);
                return;
            }
            case REJECTED: {
                child.setError((Throwable)this.result);
                return;
            }
        }
        this.addHandlers(new Consumer<T>(){

            public void consume(T result) {
                try {
                    child.setResult(result);
                }
                catch (Throwable e) {
                    child.setError(e);
                }
            }
        }, new Consumer<Throwable>(){

            public void consume(Throwable error) {
                child.setError(error);
            }
        });
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(final @NotNull AsyncFunction<? super T, SUB_RESULT> fulfilled) {
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                return fulfilled.fun(this.result);
            }
            case REJECTED: {
                return Promise.reject((Throwable)this.result);
            }
        }
        final AsyncPromise<T> promise = new AsyncPromise<T>();
        Consumer<Throwable> rejectedHandler = new Consumer<Throwable>(){

            public void consume(Throwable error) {
                promise.setError(error);
            }
        };
        this.addHandlers(new Consumer<T>((Consumer)rejectedHandler){
            final /* synthetic */ Consumer val$rejectedHandler;
            {
                this.val$rejectedHandler = consumer;
            }

            public void consume(T result) {
                try {
                    fulfilled.fun(result).done(new Consumer<SUB_RESULT>(){

                        public void consume(SUB_RESULT result) {
                            try {
                                promise.setResult(result);
                            }
                            catch (Throwable e) {
                                promise.setError(e);
                            }
                        }
                    }).rejected((Consumer<Throwable>)this.val$rejectedHandler);
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            }
        }, rejectedHandler);
        return promise;
    }

    @Override
    @NotNull
    public Promise<T> processed(final @NotNull AsyncPromise<? super T> fulfilled) {
        switch (this.state) {
            case PENDING: {
                break;
            }
            case FULFILLED: {
                fulfilled.setResult(this.result);
                return this;
            }
            case REJECTED: {
                fulfilled.setError((Throwable)this.result);
                return this;
            }
        }
        this.addHandlers(new Consumer<T>(){

            public void consume(T result) {
                try {
                    fulfilled.setResult(result);
                }
                catch (Throwable e) {
                    fulfilled.setError(e);
                }
            }
        }, new Consumer<Throwable>(){

            public void consume(Throwable error) {
                fulfilled.setError(error);
            }
        });
        return this;
    }

    private void addHandlers(@NotNull Consumer<T> done, @NotNull Consumer<Throwable> rejected) {
        this.done = AsyncPromise.setHandler(this.done, done);
        this.rejected = AsyncPromise.setHandler(this.rejected, rejected);
    }

    @NotNull
    private static <T> Consumer<? super T> setHandler(@Nullable Consumer<? super T> oldConsumer, @NotNull Consumer<? super T> newConsumer) {
        if (oldConsumer == null) {
            return newConsumer;
        }
        if (oldConsumer instanceof CompoundConsumer) {
            ((CompoundConsumer)oldConsumer).add(newConsumer);
            return oldConsumer;
        }
        return new CompoundConsumer<T>(oldConsumer, newConsumer);
    }

    public void setResult(T result) {
        if (this.state != Promise.State.PENDING) {
            return;
        }
        this.result = result;
        this.state = Promise.State.FULFILLED;
        Consumer<? super T> done = this.done;
        this.clearHandlers();
        if (done != null && !AsyncPromise.isObsolete(done)) {
            done.consume(result);
        }
    }

    static boolean isObsolete(@Nullable Consumer<?> consumer) {
        return consumer instanceof Obsolescent && ((Obsolescent)consumer).isObsolete();
    }

    public boolean setError(@NotNull String error) {
        return this.setError(Promise.createError(error));
    }

    public boolean setError(@NotNull Throwable error) {
        if (this.state != Promise.State.PENDING) {
            return false;
        }
        this.result = error;
        this.state = Promise.State.REJECTED;
        Consumer<? super Throwable> rejected = this.rejected;
        this.clearHandlers();
        if (rejected != null) {
            if (!AsyncPromise.isObsolete(rejected)) {
                rejected.consume((Object)error);
            }
        } else {
            Promise.logError(LOG, error);
        }
        return true;
    }

    private void clearHandlers() {
        this.done = null;
        this.rejected = null;
    }

    @Override
    public Promise<T> processed(final @NotNull Consumer<? super T> processed) {
        this.done(processed);
        this.rejected(new Consumer<Throwable>(){

            public void consume(Throwable error) {
                processed.consume(null);
            }
        });
        return this;
    }

    private static final class CompoundConsumer<T>
    implements Consumer<T> {
        private List<Consumer<? super T>> consumers = new ArrayList<Consumer<? super T>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompoundConsumer(@NotNull Consumer<? super T> c1, @NotNull Consumer<? super T> c2) {
            CompoundConsumer compoundConsumer = this;
            synchronized (compoundConsumer) {
                this.consumers.add(c1);
                this.consumers.add(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(T t) {
            List<Consumer<T>> list;
            CompoundConsumer compoundConsumer = this;
            synchronized (compoundConsumer) {
                list = this.consumers;
                this.consumers = null;
            }
            if (list != null) {
                for (Consumer consumer : list) {
                    if (AsyncPromise.isObsolete(consumer)) continue;
                    consumer.consume(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull Consumer<? super T> consumer) {
            CompoundConsumer compoundConsumer = this;
            synchronized (compoundConsumer) {
                if (this.consumers != null) {
                    this.consumers.add(consumer);
                }
            }
        }
    }
}

