/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.frame;

import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XValueChildrenList {
    public static final XValueChildrenList EMPTY = new XValueChildrenList(Collections.emptyList(), Collections.emptyList());
    private final List<String> myNames;
    private final List<XValue> myValues;
    private final List<XValueGroup> myTopGroups;
    private final List<XValueGroup> myBottomGroups = new SmartList();

    public XValueChildrenList(int initialCapacity) {
        this(new ArrayList<String>(initialCapacity), new ArrayList<XValue>(initialCapacity), (List<XValueGroup>)new SmartList());
    }

    public XValueChildrenList() {
        this((List<String>)new SmartList(), (List<XValue>)new SmartList(), (List<XValueGroup>)new SmartList());
    }

    private XValueChildrenList(@NotNull List<String> names, @NotNull List<XValue> values, @NotNull List<XValueGroup> topGroups) {
        this.myNames = names;
        this.myValues = values;
        this.myTopGroups = topGroups;
    }

    private XValueChildrenList(List<String> names, List<XValue> values) {
        this(names, values, (List<XValueGroup>)new SmartList());
    }

    public static XValueChildrenList singleton(String name, @NotNull XValue value) {
        return new XValueChildrenList(Collections.singletonList(name), Collections.singletonList(value));
    }

    public static XValueChildrenList singleton(@NotNull XNamedValue value) {
        return new XValueChildrenList(Collections.singletonList(value.getName()), Collections.singletonList(value));
    }

    public static XValueChildrenList bottomGroup(@NotNull XValueGroup group) {
        XValueChildrenList list = new XValueChildrenList();
        list.addBottomGroup(group);
        return list;
    }

    public static XValueChildrenList topGroups(@NotNull List<XValueGroup> topGroups) {
        return new XValueChildrenList(Collections.emptyList(), Collections.emptyList(), topGroups);
    }

    public void add(@NonNls String name, @NotNull XValue value) {
        this.myNames.add(name);
        this.myValues.add(value);
    }

    public void add(@NotNull XNamedValue value) {
        this.myNames.add(value.getName());
        this.myValues.add(value);
    }

    public void addTopGroup(@NotNull XValueGroup group) {
        this.myTopGroups.add(group);
    }

    public void addBottomGroup(@NotNull XValueGroup group) {
        this.myBottomGroups.add(group);
    }

    public int size() {
        return this.myNames.size();
    }

    public String getName(int i) {
        return this.myNames.get(i);
    }

    public XValue getValue(int i) {
        return this.myValues.get(i);
    }

    public List<XValueGroup> getTopGroups() {
        return this.myTopGroups;
    }

    public List<XValueGroup> getBottomGroups() {
        return this.myBottomGroups;
    }
}

