/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.vcs.log.VcsLogHighlighter;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCommitStyleFactory {
    public static VcsLogHighlighter.VcsCommitStyle createStyle(@Nullable Color foreground, @Nullable Color background, @Nullable VcsLogHighlighter.TextStyle textStyle) {
        return new VcsCommitStyleImpl(foreground, background, textStyle);
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle foreground(@Nullable Color foreground) {
        return VcsCommitStyleFactory.createStyle(foreground, null, null);
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle background(@Nullable Color background) {
        return VcsCommitStyleFactory.createStyle(null, background, null);
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle bold() {
        return VcsCommitStyleFactory.createStyle(null, null, VcsLogHighlighter.TextStyle.BOLD);
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle combine(@NotNull Collection<VcsLogHighlighter.VcsCommitStyle> styles) {
        Color foreground = null;
        Color background = null;
        VcsLogHighlighter.TextStyle textStyle = null;
        for (VcsLogHighlighter.VcsCommitStyle style : styles) {
            if (foreground == null) {
                foreground = style.getForeground();
            }
            if (background == null) {
                background = style.getBackground();
            }
            if (textStyle == null) {
                textStyle = style.getTextStyle();
            }
            if (background == null || foreground == null || textStyle == null) continue;
            break;
        }
        return VcsCommitStyleFactory.createStyle(foreground, background, textStyle);
    }

    private static class VcsCommitStyleImpl
    implements VcsLogHighlighter.VcsCommitStyle {
        @Nullable
        private final Color myForeground;
        @Nullable
        private final Color myBackground;
        @Nullable
        private final VcsLogHighlighter.TextStyle myTextStyle;

        public VcsCommitStyleImpl(@Nullable Color foreground, @Nullable Color background, @Nullable VcsLogHighlighter.TextStyle textStyle) {
            this.myForeground = foreground;
            this.myBackground = background;
            this.myTextStyle = textStyle;
        }

        @Override
        @Nullable
        public Color getForeground() {
            return this.myForeground;
        }

        @Override
        @Nullable
        public Color getBackground() {
            return this.myBackground;
        }

        @Override
        @Nullable
        public VcsLogHighlighter.TextStyle getTextStyle() {
            return this.myTextStyle;
        }
    }
}

