/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.DomModelCache;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.impl.CachedDomModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedMultipleDomModelFactory<Scope extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements CachedDomModelFactory<T, M, Scope>,
MultipleDomModelFactory<Scope, T, M> {
    private final DomModelCache<M, Scope> myCombinedModelCache;
    private final DomModelCache<List<M>, Scope> myAllModelsCache;

    protected CachedMultipleDomModelFactory(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger, Project project, @NonNls String name) {
        super(aClass, modelMerger);
        this.myCombinedModelCache = new DomModelCache<M, Scope>(project, name + " combined model"){

            @Override
            @NotNull
            protected CachedValueProvider.Result<M> computeValue(@NotNull Scope scope) {
                Object combinedModel = CachedMultipleDomModelFactory.this.computeCombinedModel(scope);
                return new CachedValueProvider.Result(combinedModel, CachedMultipleDomModelFactory.this.computeDependencies(combinedModel, scope));
            }
        };
        this.myAllModelsCache = new DomModelCache<List<M>, Scope>(project, name + " models list"){

            @Override
            @NotNull
            protected CachedValueProvider.Result<List<M>> computeValue(@NotNull Scope scope) {
                List models = CachedMultipleDomModelFactory.this.computeAllModels(scope);
                return new CachedValueProvider.Result(models, CachedMultipleDomModelFactory.this.computeDependencies(null, scope));
            }
        };
    }

    @Nullable
    public abstract M getModel(@NotNull C var1);

    @Override
    @NotNull
    public List<M> getAllModels(@NotNull Scope scope) {
        List<M> models = this.myAllModelsCache.getCachedValue(scope);
        if (models == null) {
            return Collections.emptyList();
        }
        return models;
    }

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull Scope var1);

    @Override
    @Nullable
    public M getCombinedModel(@Nullable Scope scope) {
        if (scope == null) {
            return null;
        }
        return (M)((DomModel)this.myCombinedModelCache.getCachedValue(scope));
    }

    @Nullable
    protected M computeCombinedModel(@NotNull Scope scope) {
        List<M> models = this.getAllModels(scope);
        switch (models.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (M)((DomModel)models.get(0));
            }
        }
        LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
        LinkedHashSet list = new LinkedHashSet(models.size());
        for (DomModel model : models) {
            Set<XmlFile> files = model.getConfigFiles();
            for (XmlFile file : files) {
                ContainerUtil.addIfNotNull(this.getDomRoot(file), list);
            }
            configFiles.addAll(files);
        }
        DomFileElement mergedModel = this.getModelMerger().mergeModels(DomFileElement.class, list);
        DomModel firstModel = (DomModel)models.get(0);
        return (M)this.createCombinedModel(configFiles, mergedModel, firstModel, scope);
    }

    protected abstract M createCombinedModel(Set<XmlFile> var1, DomFileElement<T> var2, M var3, Scope var4);

    @NotNull
    public Set<XmlFile> getConfigFiles(@Nullable C context) {
        if (context == null) {
            return Collections.emptySet();
        }
        M model = this.getModel(context);
        if (model == null) {
            return Collections.emptySet();
        }
        return model.getConfigFiles();
    }

    @Override
    @NotNull
    public Set<XmlFile> getAllConfigFiles(@NotNull Scope scope) {
        HashSet<XmlFile> xmlFiles = new HashSet<XmlFile>();
        for (DomModel model : this.getAllModels(scope)) {
            xmlFiles.addAll(model.getConfigFiles());
        }
        return xmlFiles;
    }

    public List<DomFileElement<T>> getFileElements(M model) {
        ArrayList<DomFileElement<T>> list = new ArrayList<DomFileElement<T>>(model.getConfigFiles().size());
        for (XmlFile configFile : model.getConfigFiles()) {
            DomFileElement element = DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }
}

