/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

public abstract class BaseButtonBehavior {
    private JComponent myComponent;
    private boolean myHovered;
    private boolean myPressedByMouse;
    private boolean mySelected;
    private final TimedDeadzone myMouseDeadzone;
    private int myActionTrigger;

    public BaseButtonBehavior(JComponent component) {
        this(component, TimedDeadzone.DEFAULT);
    }

    public BaseButtonBehavior(JComponent component, TimedDeadzone.Length mouseDeadzoneTime) {
        this.myComponent = component;
        this.myMouseDeadzone = new TimedDeadzone(mouseDeadzoneTime, Alarm.ThreadToUse.SWING_THREAD);
        this.myComponent.addMouseListener(new MyMouseListener());
        this.myComponent.addMouseMotionListener(new MyMouseMotionListener());
        this.setActionTrigger(502);
        if (ScreenReader.isActive()) {
            this.myComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                        e.consume();
                        RelativePoint point = new RelativePoint((Component)BaseButtonBehavior.this.myComponent, new Point(BaseButtonBehavior.this.myComponent.getWidth() / 2, BaseButtonBehavior.this.myComponent.getHeight() / 2));
                        BaseButtonBehavior.this.execute(point.toMouseEvent());
                        return;
                    }
                    super.keyReleased(e);
                }
            });
            this.myComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    BaseButtonBehavior.this.repaintComponent();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    BaseButtonBehavior.this.repaintComponent();
                }
            });
        }
    }

    public void setActionTrigger(int trigger) {
        assert (trigger == 501 || trigger == 502);
        this.myActionTrigger = trigger;
    }

    public final boolean isHovered() {
        return this.myHovered;
    }

    private void setHovered(boolean hovered) {
        this.myHovered = hovered;
        this.repaintComponent();
    }

    public final boolean isPressedByMouse() {
        return this.myPressedByMouse;
    }

    private void setPressedByMouse(boolean pressedByMouse) {
        this.myPressedByMouse = pressedByMouse;
        this.repaintComponent();
    }

    public final boolean isSelected() {
        return this.mySelected;
    }

    private void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    private boolean isPressed() {
        return this.isSelected() || this.isPressedByMouse();
    }

    public void setMouseDeadzone(TimedDeadzone.Length deadZone) {
        this.myMouseDeadzone.setLength(deadZone);
    }

    protected void repaintComponent() {
        this.repaint(this.myComponent);
    }

    protected void repaint(Component c) {
        c.repaint();
    }

    protected abstract void execute(MouseEvent var1);

    protected void pass(MouseEvent e) {
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.enter();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private boolean myWasPressedOnFocusTransfer;

        private MyMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.reEnter();
            BaseButtonBehavior.this.setHovered(true);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.clear();
            BaseButtonBehavior.this.setHovered(false);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component owner = IdeFocusManager.getInstance(null).getFocusOwner();
            this.myWasPressedOnFocusTransfer = owner == null;
            if (this.passIfNeeded(e, !this.myWasPressedOnFocusTransfer)) {
                return;
            }
            BaseButtonBehavior.this.setPressedByMouse(true);
            if (BaseButtonBehavior.this.myActionTrigger == 501) {
                if (this.execute(e)) {
                    return;
                }
            } else {
                BaseButtonBehavior.this.repaintComponent();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                if (this.passIfNeeded(e, !this.myWasPressedOnFocusTransfer)) {
                    return;
                }
                BaseButtonBehavior.this.setPressedByMouse(false);
                if (BaseButtonBehavior.this.myActionTrigger == 502) {
                    if (this.execute(e)) {
                        return;
                    }
                } else {
                    BaseButtonBehavior.this.repaintComponent();
                }
            }
            finally {
                this.myWasPressedOnFocusTransfer = false;
            }
        }

        private boolean execute(MouseEvent e) {
            Point point = e.getPoint();
            if (point.x < 0 || point.x > BaseButtonBehavior.this.myComponent.getWidth()) {
                return true;
            }
            if (point.y < 0 || point.y > BaseButtonBehavior.this.myComponent.getHeight()) {
                return true;
            }
            BaseButtonBehavior.this.repaintComponent();
            BaseButtonBehavior.this.execute(e);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!BaseButtonBehavior.this.myComponent.isShowing()) {
                        BaseButtonBehavior.this.setHovered(false);
                        BaseButtonBehavior.this.myMouseDeadzone.clear();
                    }
                }
            });
            return false;
        }

        private boolean passIfNeeded(MouseEvent e, boolean considerDeadzone) {
            boolean actionClick = UIUtil.isActionClick((MouseEvent)e, (int)BaseButtonBehavior.this.myActionTrigger);
            if (!actionClick || considerDeadzone && BaseButtonBehavior.this.myMouseDeadzone.isWithin()) {
                BaseButtonBehavior.this.pass(e);
                return true;
            }
            return false;
        }
    }
}

