/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequestBuilder {
    private static final boolean ourWrapClassLoader = SystemInfo.isJavaVersionAtLeast((String)"1.7") && !SystemProperties.getBooleanProperty((String)"idea.parallel.class.loader", (boolean)true);
    final String myUrl;
    int myConnectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
    int myTimeout = HttpConfigurable.READ_TIMEOUT;
    int myRedirectLimit = HttpConfigurable.REDIRECT_LIMIT;
    boolean myGzip = true;
    boolean myForceHttps;
    boolean myUseProxy = true;
    HostnameVerifier myHostnameVerifier;
    String myUserAgent;
    String myAccept;
    HttpRequests.ConnectionTuner myTuner;
    HTTPMethod myMethod;

    RequestBuilder(@NotNull String url) {
        this.myUrl = url;
    }

    @NotNull
    public RequestBuilder connectTimeout(int value) {
        this.myConnectTimeout = value;
        return this;
    }

    @NotNull
    public RequestBuilder readTimeout(int value) {
        this.myTimeout = value;
        return this;
    }

    @NotNull
    public RequestBuilder redirectLimit(int redirectLimit) {
        this.myRedirectLimit = redirectLimit;
        return this;
    }

    @NotNull
    public RequestBuilder gzip(boolean value) {
        this.myGzip = value;
        return this;
    }

    @NotNull
    public RequestBuilder forceHttps(boolean forceHttps) {
        this.myForceHttps = forceHttps;
        return this;
    }

    @NotNull
    public RequestBuilder useProxy(boolean useProxy) {
        this.myUseProxy = useProxy;
        return this;
    }

    @NotNull
    public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.myHostnameVerifier = hostnameVerifier;
        return this;
    }

    @NotNull
    public RequestBuilder userAgent(@Nullable String userAgent) {
        this.myUserAgent = userAgent;
        return this;
    }

    public RequestBuilder tuner(@Nullable HttpRequests.ConnectionTuner tuner) {
        this.myTuner = tuner;
        return this;
    }

    @NotNull
    public RequestBuilder productNameAsUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            ApplicationInfo info = ApplicationInfo.getInstance();
            return this.userAgent(info.getVersionName() + "/" + info.getBuild().asStringWithoutProductCode());
        }
        return this.userAgent("IntelliJ");
    }

    @NotNull
    public RequestBuilder accept(@Nullable String mimeType) {
        this.myAccept = mimeType;
        return this;
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor) throws IOException {
        if (ourWrapClassLoader) {
            return HttpRequests.wrapAndProcess(this, processor);
        }
        return HttpRequests.process(this, processor);
    }

    public int tryConnect() throws IOException {
        HttpRequests.RequestProcessor<Integer> processor = new HttpRequests.RequestProcessor<Integer>(){

            @Override
            public Integer process(@NotNull HttpRequests.Request request) throws IOException {
                URLConnection connection = request.getConnection();
                return connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
            }
        };
        if (ourWrapClassLoader) {
            return HttpRequests.wrapAndProcess(this, processor);
        }
        return HttpRequests.process(this, processor);
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor, T errorValue, @Nullable Logger logger) {
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(final @NotNull File file, final @Nullable ProgressIndicator indicator) throws IOException {
        this.connect(new HttpRequests.RequestProcessor<Void>(){

            @Override
            public Void process(@NotNull HttpRequests.Request request) throws IOException {
                request.saveToFile(file, indicator);
                return null;
            }
        });
    }

    @NotNull
    public byte[] readBytes(final @Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(new HttpRequests.RequestProcessor<byte[]>(){

            @Override
            public byte[] process(@NotNull HttpRequests.Request request) throws IOException {
                return request.readBytes(indicator);
            }
        });
    }

    @NotNull
    public String readString(final @Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(new HttpRequests.RequestProcessor<String>(){

            @Override
            public String process(@NotNull HttpRequests.Request request) throws IOException {
                int contentLength = request.getConnection().getContentLength();
                BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
                NetUtils.copyStreamContent(indicator, request.getInputStream(), (OutputStream)out, contentLength);
                return new String(out.getInternalBuffer(), 0, out.size(), HttpRequests.getCharset(request));
            }
        });
    }
}

