/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class IndexableSetContributor {
    public static final ExtensionPointName<IndexableSetContributor> EP_NAME = new ExtensionPointName("com.intellij.indexedRootsProvider");
    private static final Logger LOG = Logger.getInstance(IndexableSetContributor.class);

    @NotNull
    public static Set<VirtualFile> getProjectRootsToIndex(@NotNull IndexableSetContributor contributor, @NotNull Project project) {
        Set<VirtualFile> roots = contributor.getAdditionalProjectRootsToIndex(project);
        return IndexableSetContributor.filterOutNulls(contributor, "getAdditionalProjectRootsToIndex(Project)", roots);
    }

    @NotNull
    public static Set<VirtualFile> getRootsToIndex(@NotNull IndexableSetContributor contributor) {
        Set<VirtualFile> roots = contributor.getAdditionalRootsToIndex();
        return IndexableSetContributor.filterOutNulls(contributor, "getAdditionalRootsToIndex()", roots);
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        return Collections.emptySet();
    }

    @NotNull
    public abstract Set<VirtualFile> getAdditionalRootsToIndex();

    @NotNull
    private static Set<VirtualFile> filterOutNulls(@NotNull IndexableSetContributor contributor, @NotNull String methodInfo, @NotNull Set<VirtualFile> roots) {
        for (VirtualFile root : roots) {
            if (root != null && root.isValid()) continue;
            LOG.error("Please fix " + contributor.getClass().getName() + "#" + methodInfo + ".\n" + (root == null ? "The returned set is not expected to contain nulls, but it is " + roots : "Invalid file returned: " + root));
            return ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.filter(roots, (Condition)new Condition<VirtualFile>(){

                public boolean value(VirtualFile virtualFile) {
                    return virtualFile != null && virtualFile.isValid();
                }
            }));
        }
        return roots;
    }
}

