/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdFilter {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.DefaultFileNavigationContributor");
    private static final Key<CachedValue<IdFilter>> INSIDE_PROJECT = Key.create((String)"INSIDE_PROJECT");
    private static final Key<CachedValue<IdFilter>> OUTSIDE_PROJECT = Key.create((String)"OUTSIDE_PROJECT");

    public static IdFilter getProjectIdFilter(final Project project, final boolean includeNonProjectItems) {
        Key<CachedValue<IdFilter>> key = includeNonProjectItems ? OUTSIDE_PROJECT : INSIDE_PROJECT;
        return CachedValuesManager.getManager(project).getCachedValue(project, key, new CachedValueProvider<IdFilter>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<IdFilter> compute() {
                return CachedValueProvider.Result.create(IdFilter.buildProjectIdFilter(project, includeNonProjectItems), ProjectRootManager.getInstance(project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            }
        }, false);
    }

    @NotNull
    private static IdFilter buildProjectIdFilter(Project project, boolean includeNonProjectItems) {
        long started = System.currentTimeMillis();
        final BitSet idSet = new BitSet();
        ContentIterator iterator = new ContentIterator(){

            @Override
            public boolean processFile(VirtualFile fileOrDir) {
                int id = ((VirtualFileWithId)((Object)fileOrDir)).getId();
                if (id < 0) {
                    id = -id;
                }
                idSet.set(id);
                ProgressManager.checkCanceled();
                return true;
            }
        };
        if (!includeNonProjectItems) {
            ProjectRootManager.getInstance(project).getFileIndex().iterateContent(iterator);
        } else {
            FileBasedIndex.getInstance().iterateIndexableFiles(iterator, project, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done filter " + (System.currentTimeMillis() - started) + ":" + idSet.size());
        }
        return new IdFilter(){

            @Override
            public boolean containsFileId(int id) {
                return id >= 0 && idSet.get(id);
            }
        };
    }

    public abstract boolean containsFileId(int var1);
}

