/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class SyntaxHighlighterOverEditorHighlighter
implements SyntaxHighlighter {
    private final Lexer lexer;
    private LayeredHighlighterIterator layeredHighlighterIterator = null;
    private final SyntaxHighlighter highlighter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxHighlighterOverEditorHighlighter(SyntaxHighlighter _highlighter, VirtualFile file, Project project) {
        if (file.getFileType() == PlainTextFileType.INSTANCE) {
            this.highlighter = new PlainSyntaxHighlighter();
            this.lexer = this.highlighter.getHighlightingLexer();
        } else {
            this.highlighter = _highlighter;
            LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
            EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file);
            try {
                this.lexer = editorHighlighter instanceof LayeredLexerEditorHighlighter ? new LexerEditorHighlighterLexer(editorHighlighter, false) : this.highlighter.getHighlightingLexer();
            }
            finally {
                LayeredLexer.ourDisableLayersFlag.set(null);
            }
        }
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        return this.lexer;
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        SyntaxHighlighter activeSyntaxHighlighter = this.layeredHighlighterIterator != null ? this.layeredHighlighterIterator.getActiveSyntaxHighlighter() : this.highlighter;
        return activeSyntaxHighlighter.getTokenHighlights(tokenType);
    }

    public void restart(@NotNull CharSequence text) {
        this.lexer.start(text);
        if (this.lexer instanceof LexerEditorHighlighterLexer) {
            HighlighterIterator iterator = ((LexerEditorHighlighterLexer)this.lexer).getHighlighterIterator();
            this.layeredHighlighterIterator = iterator instanceof LayeredHighlighterIterator ? (LayeredHighlighterIterator)iterator : null;
        }
    }

    public void resetPosition(int startOffset) {
        if (this.lexer instanceof LexerEditorHighlighterLexer) {
            ((LexerEditorHighlighterLexer)this.lexer).resetPosition(startOffset);
            HighlighterIterator iterator = ((LexerEditorHighlighterLexer)this.lexer).getHighlighterIterator();
            this.layeredHighlighterIterator = iterator instanceof LayeredHighlighterIterator ? (LayeredHighlighterIterator)iterator : null;
        } else {
            CharSequence text = this.lexer.getBufferSequence();
            this.lexer.start(text, startOffset, text.length());
        }
    }
}

