/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.impl.rules.UsageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextChunk {
    public static final TextChunk[] EMPTY_ARRAY = new TextChunk[0];
    private final AttributesFlyweight myAttributes;
    private final String myText;
    private final UsageType myType;

    public TextChunk(@NotNull TextAttributes attributes, @NotNull String text) {
        this(attributes, text, null);
    }

    public TextChunk(@NotNull TextAttributes attributes, @NotNull String text, @Nullable UsageType type) {
        this.myAttributes = attributes.getFlyweight();
        this.myText = text;
        this.myType = type;
    }

    @NotNull
    public TextAttributes getAttributes() {
        return TextAttributes.fromFlyweight(this.myAttributes);
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    public String toString() {
        return this.getText();
    }

    @Nullable
    public UsageType getType() {
        return this.myType;
    }

    @NotNull
    public SimpleTextAttributes getSimpleAttributesIgnoreBackground() {
        SimpleTextAttributes simples = SimpleTextAttributes.fromTextAttributes(this.getAttributes());
        simples = new SimpleTextAttributes(null, simples.getFgColor(), simples.getWaveColor(), simples.getStyle());
        return simples;
    }
}

