/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.ui.switcher.SwitchingSession;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.Set;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchManager {
    private final Project myProject;
    private final QuickAccessSettings myQa;
    private SwitchingSession mySession;
    private boolean myWaitingForAutoInitSession;
    private final Alarm myInitSessionAlarm = new Alarm();
    private KeyEvent myAutoInitSessionEvent;
    private final Set<SwitchingSession> myFadingAway = new THashSet();

    public SwitchManager(@NotNull Project project, QuickAccessSettings quickAccess) {
        this.myProject = project;
        this.myQa = quickAccess;
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (this.isSessionActive()) {
            return false;
        }
        if (e.getID() != 401) {
            if (this.myWaitingForAutoInitSession) {
                this.cancelWaitingForAutoInit();
            }
            return false;
        }
        if (this.myQa.getModiferCodes().contains(e.getKeyCode())) {
            if (SwitchManager.areAllModifiersPressed(e.getModifiers(), this.myQa.getModiferCodes())) {
                this.myWaitingForAutoInitSession = true;
                this.myAutoInitSessionEvent = e;
                Runnable initRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IdeFocusManager.getInstance(SwitchManager.this.myProject).doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                if (SwitchManager.this.myWaitingForAutoInitSession) {
                                    SwitchManager.this.tryToInitSessionFromFocus(null, false);
                                }
                            }
                        });
                    }
                };
                if (this.myFadingAway.isEmpty()) {
                    this.myInitSessionAlarm.addRequest(initRunnable, Registry.intValue((String)"actionSystem.keyGestureHoldTime"));
                } else {
                    initRunnable.run();
                }
            }
        } else if (this.myWaitingForAutoInitSession) {
            this.cancelWaitingForAutoInit();
        }
        return false;
    }

    private ActionCallback tryToInitSessionFromFocus(@Nullable SwitchTarget preselected, boolean showSpots) {
        if (this.isSessionActive()) {
            return ActionCallback.REJECTED;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        SwitchProvider provider = SwitchProvider.KEY.getData(DataManager.getInstance().getDataContext(owner));
        if (provider != null) {
            return this.initSession(new SwitchingSession(this, provider, this.myAutoInitSessionEvent, preselected, showSpots));
        }
        return ActionCallback.REJECTED;
    }

    private void cancelWaitingForAutoInit() {
        this.myWaitingForAutoInitSession = false;
        this.myInitSessionAlarm.cancelAllRequests();
    }

    public static boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, Set<Integer> modifierCodes) {
        int mask = 0;
        for (Integer each : modifierCodes) {
            if (each == 16) {
                mask |= 1;
            }
            if (each == 17) {
                mask |= 2;
            }
            if (each == 157) {
                mask |= 4;
            }
            if (each != 18) continue;
            mask |= 8;
        }
        return (modifiers ^ mask) == 0;
    }

    public static SwitchManager getInstance(Project project) {
        return project != null ? ServiceManager.getService(project, SwitchManager.class) : null;
    }

    public SwitchingSession getSession() {
        return this.mySession;
    }

    public ActionCallback initSession(SwitchingSession session) {
        this.cancelWaitingForAutoInit();
        this.disposeCurrentSession(false);
        this.mySession = session;
        return ActionCallback.DONE;
    }

    public void disposeCurrentSession(boolean fadeAway) {
        if (this.mySession != null) {
            this.mySession.setFadeaway(fadeAway);
            Disposer.dispose((Disposable)this.mySession);
            this.mySession = null;
        }
    }

    public boolean isSessionActive() {
        return this.mySession != null && !this.mySession.isFinished();
    }

    public ActionCallback applySwitch() {
        final ActionCallback result = new ActionCallback();
        if (this.isSessionActive()) {
            final boolean showSpots = this.mySession.isShowspots();
            this.mySession.finish(false).doWhenDone(new Consumer<SwitchTarget>(){

                public void consume(final SwitchTarget switchTarget) {
                    SwitchManager.this.mySession = null;
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

                        @Override
                        public void run() {
                            SwitchManager.this.tryToInitSessionFromFocus(switchTarget, showSpots).doWhenProcessed(result.createSetDoneRunnable());
                        }
                    });
                }
            });
        } else {
            result.setDone();
        }
        return result;
    }

    public boolean canApplySwitch() {
        return this.isSessionActive() && this.mySession.isSelectionWasMoved();
    }

    public boolean isSelectionWasMoved() {
        return this.isSessionActive() && this.mySession.isSelectionWasMoved();
    }

    public void addFadingAway(SwitchingSession session) {
        this.myFadingAway.add(session);
    }

    public void removeFadingAway(SwitchingSession session) {
        this.myFadingAway.remove(session);
    }
}

