/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class JBTextField
extends JTextField
implements ComponentWithEmptyText {
    private TextComponentEmptyText myEmptyText;

    public JBTextField() {
        this.init();
    }

    public JBTextField(int i) {
        super(i);
        this.init();
    }

    public JBTextField(String s) {
        super(s);
        this.init();
    }

    public JBTextField(String s, int i) {
        super(s, i);
        this.init();
    }

    private void init() {
        UIUtil.addUndoRedoActions((JTextComponent)this);
        this.myEmptyText = new TextComponentEmptyText(this);
    }

    public void setTextToTriggerEmptyTextStatus(String t) {
        this.myEmptyText.setTextToTriggerStatus(t);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        UIUtil.resetUndoRedoActions((JTextComponent)this);
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        return this.myEmptyText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }
}

