/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SeparatorWithText
extends JComponent
implements Accessible {
    private String myCaption = "";
    private int myPrefWidth;
    private boolean myCaptionCentered = true;

    public SeparatorWithText() {
        this.setBorder(BorderFactory.createEmptyBorder(SeparatorWithText.getVgap(), 0, SeparatorWithText.getVgap(), 0));
        this.setFont(UIUtil.getLabelFont());
        this.setFont(this.getFont().deriveFont(1));
    }

    protected static int getVgap() {
        return UIUtil.isUnderNativeMacLookAndFeel() ? 1 : 3;
    }

    protected static int getHgap() {
        return 3;
    }

    public void setCaptionCentered(boolean captionCentered) {
        this.myCaptionCentered = captionCentered;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getPreferredFontSize();
        size.width = this.myPrefWidth == -1 ? size.width : this.myPrefWidth;
        return size;
    }

    private Dimension getPreferredFontSize() {
        if (this.hasCaption()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int preferredHeight = fm.getHeight();
            int preferredWidth = this.getPreferredWidth(fm);
            return new Dimension(preferredWidth, preferredHeight + SeparatorWithText.getVgap() * 2);
        }
        return new Dimension(0, SeparatorWithText.getVgap() * 2 + 1);
    }

    private int getPreferredWidth(FontMetrics fm) {
        return fm.stringWidth(this.myCaption) + 2 * SeparatorWithText.getHgap();
    }

    private boolean hasCaption() {
        return this.myCaption != null && !this.myCaption.trim().isEmpty();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMinimumWidth(int width) {
        this.myPrefWidth = width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(GroupedElementsRenderer.POPUP_SEPARATOR_FOREGROUND);
        if (this.hasCaption()) {
            Rectangle viewR = new Rectangle(0, SeparatorWithText.getVgap(), this.getWidth() - 1, this.getHeight() - SeparatorWithText.getVgap() - 1);
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            String s = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), this.myCaption, null, 0, this.myCaptionCentered ? 0 : 2, 0, this.myCaptionCentered ? 0 : 2, viewR, iconR, textR, 0);
            int lineY = textR.y + textR.height / 2;
            if (s.equals(this.myCaption) && viewR.width - textR.width > 2 * SeparatorWithText.getHgap()) {
                if (this.myCaptionCentered) {
                    g.drawLine(0, lineY, textR.x - SeparatorWithText.getHgap(), lineY);
                }
                g.drawLine(textR.x + textR.width + SeparatorWithText.getHgap(), lineY, this.getWidth() - 1, lineY);
            }
            UISettings.setupAntialiasing(g);
            g.setColor(GroupedElementsRenderer.POPUP_SEPARATOR_TEXT_FOREGROUND);
            g.drawString(s, textR.x, textR.y + g.getFontMetrics().getAscent());
        } else {
            g.drawLine(0, SeparatorWithText.getVgap(), this.getWidth() - 1, SeparatorWithText.getVgap());
        }
    }

    protected String getCaption() {
        return this.myCaption;
    }

    public void setCaption(String captionAboveOf) {
        this.myCaption = captionAboveOf;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSeparatorWithText();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSeparatorWithText
    extends JComponent.AccessibleJComponent {
        protected AccessibleSeparatorWithText() {
            super(SeparatorWithText.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public String getAccessibleName() {
            return SeparatorWithText.this.myCaption;
        }
    }
}

