/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.Function;
import com.intellij.util.ui.EditableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;

public class RowsDnDSupport {
    private RowsDnDSupport() {
    }

    public static void install(@NotNull JTable table, @NotNull EditableModel model) {
        table.setDragEnabled(true);
        RowsDnDSupport.installImpl(table, model);
    }

    public static void install(@NotNull JList list, @NotNull EditableModel model) {
        list.setDragEnabled(true);
        RowsDnDSupport.installImpl(list, model);
    }

    public static void install(@NotNull JTree tree, @NotNull EditableModel model) {
        tree.setDragEnabled(true);
        RowsDnDSupport.installImpl(tree, model);
    }

    private static void installImpl(final @NotNull JComponent component, final @NotNull EditableModel model) {
        component.setTransferHandler(new TransferHandler(null));
        DnDSupport.createBuilder(component).setBeanProvider(new Function<DnDActionInfo, DnDDragStartBean>(){

            public DnDDragStartBean fun(DnDActionInfo info) {
                Point p = info.getPoint();
                return new DnDDragStartBean(new RowDragInfo(component, RowsDnDSupport.getRow(component, p)));
            }
        }).setTargetChecker(new DnDTargetChecker(){

            @Override
            public boolean update(DnDEvent event) {
                Object o = event.getAttachedObject();
                if (!(o instanceof RowDragInfo) || ((RowDragInfo)o).component != component) {
                    event.setDropPossible(false, "");
                    return true;
                }
                event.setDropPossible(true);
                int oldIndex = ((RowDragInfo)o).row;
                int newIndex = RowsDnDSupport.getRow(component, event.getPoint());
                if (newIndex == -1) {
                    event.setDropPossible(false, "");
                    return true;
                }
                Rectangle cellBounds = RowsDnDSupport.getCellBounds(component, newIndex);
                if (model instanceof RefinedDropSupport) {
                    RefinedDropSupport.Position position = ((RefinedDropSupport)model).isDropInto(component, oldIndex, newIndex) ? RefinedDropSupport.Position.INTO : (event.getPoint().y < cellBounds.y + cellBounds.height / 2 ? RefinedDropSupport.Position.ABOVE : RefinedDropSupport.Position.BELOW);
                    boolean canDrop = ((RefinedDropSupport)model).canDrop(oldIndex, newIndex, position);
                    event.setDropPossible(canDrop);
                    if (canDrop && oldIndex != newIndex) {
                        if (position == RefinedDropSupport.Position.BELOW) {
                            cellBounds.y += cellBounds.height - 2;
                        }
                        RelativeRectangle rectangle = new RelativeRectangle((Component)component, cellBounds);
                        switch (position) {
                            case INTO: {
                                event.setHighlighting(rectangle, 1);
                                break;
                            }
                            case ABOVE: 
                            case BELOW: {
                                rectangle.getDimension().height = 2;
                                event.setHighlighting(rectangle, 2);
                            }
                        }
                        return true;
                    }
                    event.hideHighlighter();
                    return true;
                }
                if (oldIndex == newIndex) {
                    return true;
                }
                boolean canExchange = model.canExchangeRows(oldIndex, newIndex);
                if (canExchange) {
                    if (oldIndex < newIndex) {
                        cellBounds.y += cellBounds.height - 2;
                    }
                    RelativeRectangle rectangle = new RelativeRectangle((Component)component, cellBounds);
                    rectangle.getDimension().height = 2;
                    event.setDropPossible(true);
                    event.setHighlighting(rectangle, 2);
                } else {
                    event.setDropPossible(false);
                }
                return true;
            }
        }).setDropHandler(new DnDDropHandler(){

            @Override
            public void drop(DnDEvent event) {
                Object o = event.getAttachedObject();
                Point p = event.getPoint();
                if (o instanceof RowDragInfo && ((RowDragInfo)o).component == component) {
                    int oldIndex = ((RowDragInfo)o).row;
                    if (oldIndex == -1) {
                        return;
                    }
                    int newIndex = RowsDnDSupport.getRow(component, p);
                    if (newIndex == -1) {
                        newIndex = RowsDnDSupport.getRowCount(component) - 1;
                    }
                    if (oldIndex != newIndex) {
                        if (model instanceof RefinedDropSupport) {
                            RefinedDropSupport.Position position;
                            Rectangle cellBounds = RowsDnDSupport.getCellBounds(component, newIndex);
                            RefinedDropSupport.Position position2 = ((RefinedDropSupport)model).isDropInto(component, oldIndex, newIndex) ? RefinedDropSupport.Position.INTO : (position = event.getPoint().y < cellBounds.y + cellBounds.height / 2 ? RefinedDropSupport.Position.ABOVE : RefinedDropSupport.Position.BELOW);
                            if (((RefinedDropSupport)model).canDrop(oldIndex, newIndex, position)) {
                                ((RefinedDropSupport)model).drop(oldIndex, newIndex, position);
                            }
                        } else if (model.canExchangeRows(oldIndex, newIndex)) {
                            model.exchangeRows(oldIndex, newIndex);
                            RowsDnDSupport.setSelectedRow(component, newIndex);
                        }
                    }
                }
                event.hideHighlighter();
            }
        }).install();
    }

    private static int getRow(JComponent component, Point point) {
        if (component instanceof JTable) {
            return ((JTable)component).rowAtPoint(point);
        }
        if (component instanceof JList) {
            return ((JList)component).locationToIndex(point);
        }
        if (component instanceof JTree) {
            return ((JTree)component).getClosestRowForLocation(point.x, point.y);
        }
        throw new IllegalArgumentException("Unsupported component: " + component);
    }

    private static int getRowCount(JComponent component) {
        if (component instanceof JTable) {
            return ((JTable)component).getRowCount();
        }
        if (component instanceof JList) {
            return ((JList)component).getModel().getSize();
        }
        if (component instanceof JTree) {
            return ((JTree)component).getRowCount();
        }
        throw new IllegalArgumentException("Unsupported component: " + component);
    }

    private static Rectangle getCellBounds(JComponent component, int row) {
        if (component instanceof JTable) {
            Rectangle rectangle = ((JTable)component).getCellRect(row, 0, true);
            rectangle.width = component.getWidth();
            return rectangle;
        }
        if (component instanceof JList) {
            return ((JList)component).getCellBounds(row, row);
        }
        if (component instanceof JTree) {
            return ((JTree)component).getRowBounds(row);
        }
        throw new IllegalArgumentException("Unsupported component: " + component);
    }

    private static void setSelectedRow(JComponent component, int row) {
        if (component instanceof JTable) {
            ((JTable)component).getSelectionModel().setSelectionInterval(row, row);
        } else if (component instanceof JList) {
            ((JList)component).setSelectedIndex(row);
        } else if (component instanceof JTree) {
            ((JTree)component).setSelectionRow(row);
        } else {
            throw new IllegalArgumentException("Unsupported component: " + component);
        }
    }

    public static interface RefinedDropSupport {
        public boolean isDropInto(JComponent var1, int var2, int var3);

        public boolean canDrop(int var1, int var2, @NotNull Position var3);

        public void drop(int var1, int var2, @NotNull Position var3);

        public static enum Position {
            ABOVE,
            INTO,
            BELOW;

        }
    }

    private static class RowDragInfo {
        public final JComponent component;
        public final int row;

        RowDragInfo(JComponent component, int row) {
            this.component = component;
            this.row = row;
        }
    }
}

