/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.AbstractSizeAdjustingIcon;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RowIcon
extends AbstractSizeAdjustingIcon {
    private final Alignment myAlignment;
    private float myScale = 1.0f;
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;

    public RowIcon(int iconCount) {
        this(iconCount, Alignment.TOP);
    }

    public RowIcon(int iconCount, Alignment alignment) {
        this.myAlignment = alignment;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(Icon ... icons) {
        this(icons.length);
        System.arraycopy(icons, 0, this.myIcons, 0, icons.length);
        this.adjustSize();
    }

    @Override
    public Icon scale(float scale) {
        if (this.myScale != scale || this.myScale != 1.0f && this.myScaledIcons == null) {
            this.myScale = scale;
            this.rescale();
        }
        return this;
    }

    private void rescale() {
        if (this.myScale == 1.0f) {
            this.myScaledIcons = null;
            return;
        }
        for (Icon icon : this.myIcons) {
            if (icon == null || icon instanceof ScalableIcon) continue;
            return;
        }
        this.myScaledIcons = new Icon[this.myIcons.length];
        for (int i = 0; i < this.myIcons.length; ++i) {
            ScalableIcon icon = (ScalableIcon)this.myIcons[i];
            this.myScaledIcons[i] = icon == null ? null : icon.scale(this.myScale);
        }
        this.adjustSize();
    }

    @NotNull
    Icon[] getAllIcons() {
        List icons = ContainerUtil.packNullables((Object[])this.myIcons);
        return icons.toArray(new Icon[icons.size()]);
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public void setIcon(Icon icon, int layer) {
        this.myIcons[layer] = icon;
        this.rescale();
        this.adjustSize();
    }

    public Icon getIcon(int index) {
        return this.myIcons[index];
    }

    public Icon[] getIcons() {
        Icon[] icons = this.myScale == 1.0f ? this.myIcons : this.myScaledIcons;
        return icons == null ? this.myIcons : icons;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int _x = x;
        int _y = y;
        for (Icon icon : this.getIcons()) {
            if (icon == null) continue;
            switch (this.myAlignment) {
                case TOP: {
                    _y = y;
                    break;
                }
                case CENTER: {
                    _y = y + (this.myHeight - icon.getIconHeight()) / 2;
                    break;
                }
                case BOTTOM: {
                    _y = y + (this.myHeight - icon.getIconHeight());
                }
            }
            icon.paintIcon(c, g, _x, _y);
            _x += icon.getIconWidth();
        }
    }

    @Override
    protected void adjustSize() {
        int width = 0;
        int height = 0;
        for (Icon icon : this.getIcons()) {
            if (icon == null) continue;
            width += icon.getIconWidth();
            height = Math.max(height, icon.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }

    public String toString() {
        return "Row icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

