/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PopupHandler
extends MouseAdapter {
    public abstract void invokePopup(Component var1, int var2, int var3);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public static void installPopupHandler(JComponent component, @NonNls String groupId, String place) {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction(groupId);
        PopupHandler.installPopupHandler(component, group, place, ActionManager.getInstance());
    }

    public static MouseListener installPopupHandler(JComponent component, final @NotNull ActionGroup group, final String place, final ActionManager actionManager) {
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler popupHandler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                popupMenu.getComponent().show(comp, x, y);
            }
        };
        component.addMouseListener(popupHandler);
        return popupHandler;
    }

    public static MouseListener installFollowingSelectionTreePopup(final JTree tree, final @NotNull ActionGroup group, final String place, final ActionManager actionManager) {
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler handler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                if (tree.getPathForLocation(x, y) != null && Arrays.binarySearch(tree.getSelectionRows(), tree.getRowForLocation(x, y)) > -1) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        };
        tree.addMouseListener(handler);
        return handler;
    }

    public static MouseListener installUnknownPopupHandler(JComponent component, ActionGroup group, ActionManager actionManager) {
        return PopupHandler.installPopupHandler(component, group, "unknown", actionManager);
    }
}

