/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent = "";
    private Language myLanguage;
    private boolean myReadOnly;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls @NotNull String name) {
        this(name, "");
    }

    public LightVirtualFile(@NonNls @NotNull String name, @NotNull CharSequence content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text) {
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, @NotNull CharSequence text, long modificationStamp) {
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text, long modificationStamp) {
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text, Charset charset, long modificationStamp) {
        super(name, fileType, modificationStamp);
        this.setContent(text);
        this.setCharset(charset);
    }

    public LightVirtualFile(@NotNull String name, Language language, @NotNull CharSequence text) {
        super(name, null, LocalTimeCounter.currentTime());
        this.setContent(text);
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        this.myLanguage = language;
        FileType type = language.getAssociatedFileType();
        if (type == null) {
            type = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName());
        }
        this.setFileType(type);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        return VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    String content = this.toString(LightVirtualFile.this.getCharset().name());
                    LightVirtualFile.this.setContent(content);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        return s.getBytes(charset.name());
    }

    public void setContent(Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        this.setContent(content);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContent(@NotNull CharSequence content) {
        assert (!this.myReadOnly);
        this.myContent = content;
    }

    @NotNull
    public CharSequence getContent() {
        return this.myContent;
    }

    public void markReadOnly() {
        this.setWritable(false);
        this.myReadOnly = true;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }
}

