/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet((short)Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return false;
        }
    };
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i);
    }

    @NotNull
    public IElementType[] getTypes() {
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list = new ArrayList<IElementType>();
                for (short i = (short)Math.max(1, this.myShift << 6); i <= this.myMax; i = (short)(i + 1)) {
                    IElementType type;
                    if (!this.get(i) || (type = IElementType.find(i)) == null) continue;
                    list.add(type);
                }
                types = list.toArray(new IElementType[list.size()]);
            }
            this.myTypes = types;
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        short s;
        if (types.length == 0) {
            return EMPTY;
        }
        int n = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type : types) {
            if (type == null) continue;
            short index = type.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass((Object)type);
            if (s > index) {
                s = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(s >> 6);
        TokenSet set = new TokenSet(shift, max);
        for (IElementType type : types) {
            int wordIndex;
            if (type == null) continue;
            short index = type.getIndex();
            int n2 = wordIndex = (index >> 6) - shift;
            set.myWords[n2] = set.myWords[n2] | 1L << index;
        }
        return set;
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets.length == 0) {
            return EMPTY;
        }
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i = 1; i < sets.length; ++i) {
            if (shift > sets[i].myShift) {
                shift = sets[i].myShift;
            }
            if (max >= sets[i].myMax) continue;
            max = sets[i].myMax;
        }
        TokenSet newSet = new TokenSet(shift, max);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i = 0; i < set.myWords.length; ++i) {
                int n = i + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i];
            }
        }
        return newSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a, @NotNull TokenSet b) {
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & (0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L);
        }
        return newSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a, @NotNull TokenSet b) {
        TokenSet newSet = new TokenSet((short)Math.min(a.myShift, b.myShift), (short)Math.max(a.myMax, b.myMax));
        for (int i = 0; i < newSet.myWords.length; ++i) {
            int ai = newSet.myShift - a.myShift + i;
            int bi = newSet.myShift - b.myShift + i;
            newSet.myWords[i] = (0 <= ai && ai < a.myWords.length ? a.myWords[ai] : 0L) & ((0 <= bi && bi < b.myWords.length ? b.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return newSet;
    }
}

