/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnionPackageSet
extends PackageSetBase {
    private final PackageSet myFirstSet;
    private final PackageSet mySecondSet;
    private String myText;

    public UnionPackageSet(@NotNull PackageSet set1, @NotNull PackageSet set2) {
        this.myFirstSet = set1;
        this.mySecondSet = set2;
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull NamedScopesHolder holder) {
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        return (!(this.myFirstSet instanceof PackageSetBase) ? this.myFirstSet.contains(UnionPackageSet.getPsiFile(file, project), holder) : ((PackageSetBase)this.myFirstSet).contains(file, project, holder)) || (this.mySecondSet instanceof PackageSetBase ? ((PackageSetBase)this.mySecondSet).contains(file, project, holder) : this.mySecondSet.contains(UnionPackageSet.getPsiFile(file, project), holder));
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return new UnionPackageSet(this.myFirstSet.createCopy(), this.mySecondSet.createCopy());
    }

    @Override
    public int getNodePriority() {
        return 3;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText == null) {
            this.myText = this.myFirstSet.getText() + "||" + this.mySecondSet.getText();
        }
        return this.myText;
    }

    public PackageSet getFirstSet() {
        return this.myFirstSet;
    }

    public PackageSet getSecondSet() {
        return this.mySecondSet;
    }
}

